"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub,
    ctx,
    instance_id: str,
    instance_os_user: str,
    ssh_public_key: str,
    availability_zone: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60 seconds. For more information, see Connect to your Linux instance using EC2 Instance Connect in the Amazon EC2 User Guide.

    Args:
        instance_id(str): The ID of the EC2 instance.
        instance_os_user(str): The OS user on the EC2 instance for whom the key can be used to authenticate.
        ssh_public_key(str): The public key material. To use the public key, you must have the matching private key.
        availability_zone(str): The Availability Zone in which the EC2 instance was launched.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2_instance_connect.ssh_public_key.send(
                ctx,
                instance_id=value,
                instance_os_user=value,
                ssh_public_key=value,
                availability_zone=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2_instance_connect.ssh_public_key.send instance_id=value, instance_os_user=value, ssh_public_key=value, availability_zone=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2-instance-connect",
        operation="send_ssh_public_key",
        op_kwargs={
            "InstanceId": instance_id,
            "InstanceOSUser": instance_os_user,
            "SSHPublicKey": ssh_public_key,
            "AvailabilityZone": availability_zone,
        },
    )
