"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub, ctx, instance_id: str, ssh_public_key: str, serial_port: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60 seconds to establish a serial console connection to the instance using SSH. For more information, see EC2 Serial Console in the Amazon EC2 User Guide.

    Args:
        instance_id(str): The ID of the EC2 instance.
        serial_port(int, optional): The serial port of the EC2 instance. Currently only port 0 is supported. Default: 0. Defaults to None.
        ssh_public_key(str): The public key material. To use the public key, you must have the matching private key. For information about the supported key formats and lengths, see Requirements for key pairs in the Amazon EC2 User Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2_instance_connect.serial_console_ssh_public_key.send(
                ctx, instance_id=value, ssh_public_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2_instance_connect.serial_console_ssh_public_key.send instance_id=value, ssh_public_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2-instance-connect",
        operation="send_serial_console_ssh_public_key",
        op_kwargs={
            "InstanceId": instance_id,
            "SerialPort": serial_port,
            "SSHPublicKey": ssh_public_key,
        },
    )
