"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    vpn_connection_id: str,
    vpn_tunnel_outside_ip_address: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the VPN tunnel endpoint certificate.

    Args:
        vpn_connection_id(str): The ID of the AWS Site-to-Site VPN connection.
        vpn_tunnel_outside_ip_address(str): The external IP address of the VPN tunnel.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.tunnel.certificate.modify(
                ctx, vpn_connection_id=value, vpn_tunnel_outside_ip_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.tunnel.certificate.modify vpn_connection_id=value, vpn_tunnel_outside_ip_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpn_tunnel_certificate",
        op_kwargs={
            "VpnConnectionId": vpn_connection_id,
            "VpnTunnelOutsideIpAddress": vpn_tunnel_outside_ip_address,
            "DryRun": dry_run,
        },
    )
