"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def create(hub, ctx, destination_cidr_block: str, vpn_connection_id: str) -> None:
    r"""
    **Autogenerated function**

    Creates a static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway. For more information, see AWS Site-to-Site VPN in the AWS Site-to-Site VPN User Guide.

    Args:
        destination_cidr_block(str): The CIDR block associated with the local subnet of the customer network.
        vpn_connection_id(str): The ID of the VPN connection.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.route.create(
                ctx, destination_cidr_block=value, vpn_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.route.create destination_cidr_block=value, vpn_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpn_connection_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "VpnConnectionId": vpn_connection_id,
        },
    )


async def delete(hub, ctx, destination_cidr_block: str, vpn_connection_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified static route associated with a VPN connection between an existing virtual private gateway and a VPN customer gateway. The static route allows traffic to be routed from the virtual private gateway to the VPN customer gateway.

    Args:
        destination_cidr_block(str): The CIDR block associated with the local subnet of the customer network.
        vpn_connection_id(str): The ID of the VPN connection.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.route.delete(
                ctx, destination_cidr_block=value, vpn_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.route.delete destination_cidr_block=value, vpn_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpn_connection_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "VpnConnectionId": vpn_connection_id,
        },
    )
