"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    vpn_connection_id: str,
    local_ipv4_network_cidr: str = None,
    remote_ipv4_network_cidr: str = None,
    local_ipv6_network_cidr: str = None,
    remote_ipv6_network_cidr: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the connection options for your Site-to-Site VPN connection. When you modify the VPN connection options, the VPN endpoint IP addresses on the AWS side do not change, and the tunnel options do not change. Your VPN connection will be temporarily unavailable for a brief period while the VPN connection is updated.

    Args:
        vpn_connection_id(str): The ID of the Site-to-Site VPN connection. .
        local_ipv4_network_cidr(str, optional): The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection. Default: 0.0.0.0/0 . Defaults to None.
        remote_ipv4_network_cidr(str, optional): The IPv4 CIDR on the AWS side of the VPN connection. Default: 0.0.0.0/0 . Defaults to None.
        local_ipv6_network_cidr(str, optional): The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection. Default: ::/0 . Defaults to None.
        remote_ipv6_network_cidr(str, optional): The IPv6 CIDR on the AWS side of the VPN connection. Default: ::/0 . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.option.modify(ctx, vpn_connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.option.modify vpn_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpn_connection_options",
        op_kwargs={
            "VpnConnectionId": vpn_connection_id,
            "LocalIpv4NetworkCidr": local_ipv4_network_cidr,
            "RemoteIpv4NetworkCidr": remote_ipv4_network_cidr,
            "LocalIpv6NetworkCidr": local_ipv6_network_cidr,
            "RemoteIpv6NetworkCidr": remote_ipv6_network_cidr,
            "DryRun": dry_run,
        },
    )
