"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    customer_gateway_id: str,
    type_: str,
    vpn_gateway_id: str = None,
    transit_gateway_id: str = None,
    dry_run: bool = None,
    options: Dict = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPN connection between an existing virtual private gateway or transit gateway and a customer gateway. The supported connection type is ipsec.1. The response includes information that you need to give to your network administrator to configure your customer gateway.  We strongly recommend that you use HTTPS when calling this operation because the response contains sensitive cryptographic information for configuring your customer gateway device.  If you decide to shut down your VPN connection for any reason and later create a new VPN connection, you must reconfigure your customer gateway with the new information returned from this call. This is an idempotent operation. If you perform the operation more than once, Amazon EC2 doesn't return an error. For more information, see AWS Site-to-Site VPN in the AWS Site-to-Site VPN User Guide.

    Args:
        customer_gateway_id(str): The ID of the customer gateway.
        type_(str): The type of VPN connection (ipsec.1).
        vpn_gateway_id(str, optional): The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit gateway. Defaults to None.
        transit_gateway_id(str, optional): The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private gateway. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        options(Dict, optional): The options for the VPN connection. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the VPN connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.init.create(
                ctx, customer_gateway_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.init.create customer_gateway_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpn_connection",
        op_kwargs={
            "CustomerGatewayId": customer_gateway_id,
            "Type": type_,
            "VpnGatewayId": vpn_gateway_id,
            "TransitGatewayId": transit_gateway_id,
            "DryRun": dry_run,
            "Options": options,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(hub, ctx, vpn_connection_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified VPN connection. If you're deleting the VPC and its associated components, we recommend that you detach the virtual private gateway from the VPC and delete the VPC before deleting the VPN connection. If you believe that the tunnel credentials for your VPN connection have been compromised, you can delete the VPN connection and create a new one that has new keys, without needing to delete the VPC or virtual private gateway. If you create a new VPN connection, you must reconfigure the customer gateway device using the new configuration information returned with the new VPN connection ID. For certificate-based authentication, delete all AWS Certificate Manager (ACM) private certificates used for the AWS-side tunnel endpoints for the VPN connection before deleting the VPN connection.

    Args:
        vpn_connection_id(str): The ID of the VPN connection.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.init.delete(ctx, vpn_connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.init.delete vpn_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpn_connection",
        op_kwargs={"VpnConnectionId": vpn_connection_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    vpn_connection_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your VPN connections. For more information, see AWS Site-to-Site VPN in the AWS Site-to-Site VPN User Guide.

    Args:
        filters(List, optional): One or more filters.    customer-gateway-configuration - The configuration information for the customer gateway.    customer-gateway-id - The ID of a customer gateway associated with the VPN connection.    state - The state of the VPN connection (pending | available | deleting | deleted).    option.static-routes-only - Indicates whether the connection has static routes only. Used for devices that do not support Border Gateway Protocol (BGP).    route.destination-cidr-block - The destination CIDR block. This corresponds to the subnet used in a customer data center.    bgp-asn - The BGP Autonomous System Number (ASN) associated with a BGP device.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.    type - The type of VPN connection. Currently the only supported type is ipsec.1.    vpn-connection-id - The ID of the VPN connection.    vpn-gateway-id - The ID of a virtual private gateway associated with the VPN connection.    transit-gateway-id - The ID of a transit gateway associated with the VPN connection.  . Defaults to None.
        vpn_connection_ids(List, optional): One or more VPN connection IDs. Default: Describes your VPN connections. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpn_connections",
        op_kwargs={
            "Filters": filters,
            "VpnConnectionIds": vpn_connection_ids,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    vpn_connection_id: str,
    transit_gateway_id: str = None,
    customer_gateway_id: str = None,
    vpn_gateway_id: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the customer gateway or the target gateway of an AWS Site-to-Site VPN connection. To modify the target gateway, the following migration options are available:   An existing virtual private gateway to a new virtual private gateway   An existing virtual private gateway to a transit gateway   An existing transit gateway to a new transit gateway   An existing transit gateway to a virtual private gateway   Before you perform the migration to the new gateway, you must configure the new gateway. Use CreateVpnGateway to create a virtual private gateway, or CreateTransitGateway to create a transit gateway. This step is required when you migrate from a virtual private gateway with static routes to a transit gateway.  You must delete the static routes before you migrate to the new gateway. Keep a copy of the static route before you delete it. You will need to add back these routes to the transit gateway after the VPN connection migration is complete. After you migrate to the new gateway, you might need to modify your VPC route table. Use CreateRoute and DeleteRoute to make the changes described in VPN Gateway Target Modification Required VPC Route Table Updates in the AWS Site-to-Site VPN User Guide.  When the new gateway is a transit gateway, modify the transit gateway route table to allow traffic between the VPC and the AWS Site-to-Site VPN connection. Use CreateTransitGatewayRoute to add the routes.  If you deleted VPN static routes, you must add the static routes to the transit gateway route table. After you perform this operation, the AWS VPN endpoint's IP addresses on the AWS side and the tunnel options remain intact. Your AWS Site-to-Site VPN connection will be temporarily unavailable for a brief period while we provision the new endpoints.

    Args:
        vpn_connection_id(str): The ID of the VPN connection.
        transit_gateway_id(str, optional): The ID of the transit gateway. Defaults to None.
        customer_gateway_id(str, optional): The ID of the customer gateway at your end of the VPN connection. Defaults to None.
        vpn_gateway_id(str, optional): The ID of the virtual private gateway at the AWS side of the VPN connection. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpn.connection.init.modify(ctx, vpn_connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpn.connection.init.modify vpn_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpn_connection",
        op_kwargs={
            "VpnConnectionId": vpn_connection_id,
            "TransitGatewayId": transit_gateway_id,
            "CustomerGatewayId": customer_gateway_id,
            "VpnGatewayId": vpn_gateway_id,
            "DryRun": dry_run,
        },
    )
