"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub, ctx, vpc_id: str, instance_tenancy: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the instance tenancy attribute of the specified VPC. You can change the instance tenancy attribute of a VPC to default only. You cannot change the instance tenancy attribute to dedicated. After you modify the tenancy of the VPC, any new instances that you launch into the VPC have a tenancy of default, unless you specify otherwise during launch. The tenancy of any existing instances in the VPC is not affected. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.

    Args:
        vpc_id(str): The ID of the VPC.
        instance_tenancy(str): The instance tenancy attribute for the VPC. .
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.tenancy.modify(
                ctx, vpc_id=value, instance_tenancy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.tenancy.modify vpc_id=value, instance_tenancy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_tenancy",
        op_kwargs={
            "VpcId": vpc_id,
            "InstanceTenancy": instance_tenancy,
            "DryRun": dry_run,
        },
    )
