"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cidr_block: str,
    amazon_provided_ipv6_cidr_block: bool = None,
    ipv6_pool: str = None,
    ipv6_cidr_block: str = None,
    dry_run: bool = None,
    instance_tenancy: str = None,
    ipv6_cidr_block_network_border_group: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you can create uses a /28 netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536 IPv4 addresses). For more information about how large to make your VPC, see Your VPC and subnets in the Amazon Virtual Private Cloud User Guide. You can optionally request an IPv6 CIDR block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6 addresses, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). By default, each instance you launch in the VPC has the default DHCP options, which include only a default DNS server that we provide (AmazonProvidedDNS). For more information, see DHCP options sets in the Amazon Virtual Private Cloud User Guide. You can specify the instance tenancy value for the VPC when you create it. You can't change this value for the VPC after you create it. For more information, see Dedicated Instances in the Amazon Elastic Compute Cloud User Guide.

    Args:
        cidr_block(str): The IPv4 network range for the VPC, in CIDR notation. For example, 10.0.0.0/16. We modify the specified CIDR block to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
        amazon_provided_ipv6_cidr_block(bool, optional): Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Defaults to None.
        ipv6_pool(str, optional): The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. Defaults to None.
        ipv6_cidr_block(str, optional): The IPv6 CIDR block from the IPv6 address pool. You must also specify Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this parameter. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_tenancy(str, optional): The tenancy options for instances launched into the VPC. For default, instances are launched with shared tenancy by default. You can launch instances with any tenancy into a shared tenancy VPC. For dedicated, instances are launched as dedicated tenancy instances by default. You can only launch instances with a tenancy of dedicated or host into a dedicated tenancy VPC.   Important: The host value cannot be used with this parameter. Use the default or dedicated values only. Default: default . Defaults to None.
        ipv6_cidr_block_network_border_group(str, optional): The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.  You must set AmazonProvidedIpv6CidrBlock to true to use this parameter. Defaults to None.
        tag_specifications(List, optional): The tags to assign to the VPC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.init.create(ctx, cidr_block=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.init.create cidr_block=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpc",
        op_kwargs={
            "CidrBlock": cidr_block,
            "AmazonProvidedIpv6CidrBlock": amazon_provided_ipv6_cidr_block,
            "Ipv6Pool": ipv6_pool,
            "Ipv6CidrBlock": ipv6_cidr_block,
            "DryRun": dry_run,
            "InstanceTenancy": instance_tenancy,
            "Ipv6CidrBlockNetworkBorderGroup": ipv6_cidr_block_network_border_group,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete(hub, ctx, vpc_id: str, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.

    Args:
        vpc_id(str): The ID of the VPC.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.init.delete(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.init.delete vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpc",
        op_kwargs={"VpcId": vpc_id, "DryRun": dry_run},
    )


async def describe_all(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified VPC. You must detach or delete all gateways and resources that are associated with the VPC before you can delete it. For example, you must terminate all instances running in the VPC, delete all security groups associated with the VPC (except the default one), delete all route tables associated with the VPC (except the default one), and so on.

    Args:
        vpc_id(str): The ID of the VPC.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.init.delete(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.init.delete vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpcs",
        op_kwargs={},
    )
