"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    service_id: str,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the principals (service consumers) that are permitted to discover your VPC endpoint service.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str): The ID of the service.
        filters(List, optional): One or more filters.    principal - The ARN of the principal.    principal-type - The principal type (All | Service | OrganizationUnit | Account | User | Role).  . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given a value larger than 1,000, only 1,000 results are returned. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.permission.describe_all(
                ctx, service_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.permission.describe_all service_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_endpoint_service_permissions",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    service_id: str,
    dry_run: bool = None,
    add_allowed_principals: List = None,
    remove_allowed_principals: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the permissions for your VPC endpoint service. You can add or remove permissions for service consumers (IAM users, IAM roles, and AWS accounts) to connect to your endpoint service. If you grant permissions to all principals, the service is public. Any users who know the name of a public service can send a request to attach an endpoint. If the service does not require manual approval, attachments are automatically approved.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str): The ID of the service.
        add_allowed_principals(List, optional): The Amazon Resource Names (ARN) of one or more principals. Permissions are granted to the principals in this list. To grant permissions to all principals, specify an asterisk (*). Defaults to None.
        remove_allowed_principals(List, optional): The Amazon Resource Names (ARN) of one or more principals. Permissions are revoked for principals in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.permission.modify(
                ctx, service_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.permission.modify service_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_endpoint_service_permissions",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "AddAllowedPrincipals": add_allowed_principals,
            "RemoveAllowedPrincipals": remove_allowed_principals,
        },
    )
