"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    dry_run: bool = None,
    acceptance_required: bool = None,
    private_dns_name: str = None,
    network_load_balancer_arns: List = None,
    gateway_load_balancer_arns: List = None,
    client_token: str = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles) can connect. To create an endpoint service configuration, you must first create one of the following for your service:   A Network Load Balancer. Service consumers connect to your service using an interface endpoint.   A Gateway Load Balancer. Service consumers connect to your service using a Gateway Load Balancer endpoint.   For more information, see VPC Endpoint Services in the Amazon Virtual Private Cloud User Guide.  If you set the private DNS name, you must prove that you own the private DNS domain name. For more information, see VPC Endpoint Service Private DNS Name Verification in the Amazon Virtual Private Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        acceptance_required(bool, optional): Indicates whether requests from service consumers to create an endpoint to your service must be accepted. To accept a request, use AcceptVpcEndpointConnections. Defaults to None.
        private_dns_name(str, optional): (Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service. Defaults to None.
        network_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your service. Defaults to None.
        gateway_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        tag_specifications(List, optional): The tags to associate with the service. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.configuration.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.configuration.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpc_endpoint_service_configuration",
        op_kwargs={
            "DryRun": dry_run,
            "AcceptanceRequired": acceptance_required,
            "PrivateDnsName": private_dns_name,
            "NetworkLoadBalancerArns": network_load_balancer_arns,
            "GatewayLoadBalancerArns": gateway_load_balancer_arns,
            "ClientToken": client_token,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete_multiple(hub, ctx, service_ids: List, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more VPC endpoint service configurations in your account. Before you delete the endpoint service configuration, you must reject any Available or PendingAcceptance interface endpoint connections that are attached to the service.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_ids(List): The IDs of one or more services.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.configuration.delete_multiple(
                ctx, service_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.configuration.delete_multiple service_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpc_endpoint_service_configurations",
        op_kwargs={"DryRun": dry_run, "ServiceIds": service_ids},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    service_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the VPC endpoint service configurations in your account (your services).

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_ids(List, optional): The IDs of one or more services. Defaults to None.
        filters(List, optional): One or more filters.    service-name - The name of the service.    service-id - The ID of the service.    service-state - The state of the service (Pending | Available | Deleting | Deleted | Failed).     tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given a value larger than 1,000, only 1,000 results are returned. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_endpoint_service_configurations",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceIds": service_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    service_id: str,
    dry_run: bool = None,
    private_dns_name: str = None,
    remove_private_dns_name: bool = None,
    acceptance_required: bool = None,
    add_network_load_balancer_arns: List = None,
    remove_network_load_balancer_arns: List = None,
    add_gateway_load_balancer_arns: List = None,
    remove_gateway_load_balancer_arns: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the attributes of your VPC endpoint service configuration. You can change the Network Load Balancers or Gateway Load Balancers for your service, and you can specify whether acceptance is required for requests to connect to your endpoint service through an interface VPC endpoint. If you set or modify the private DNS name, you must prove that you own the private DNS domain name. For more information, see VPC Endpoint Service Private DNS Name Verification in the Amazon Virtual Private Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str): The ID of the service.
        private_dns_name(str, optional): (Interface endpoint configuration) The private DNS name to assign to the endpoint service. Defaults to None.
        remove_private_dns_name(bool, optional): (Interface endpoint configuration) Removes the private DNS name of the endpoint service. Defaults to None.
        acceptance_required(bool, optional): Indicates whether requests to create an endpoint to your service must be accepted. Defaults to None.
        add_network_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of Network Load Balancers to add to your service configuration. Defaults to None.
        remove_network_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of Network Load Balancers to remove from your service configuration. Defaults to None.
        add_gateway_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of Gateway Load Balancers to add to your service configuration. Defaults to None.
        remove_gateway_load_balancer_arns(List, optional): The Amazon Resource Names (ARNs) of Gateway Load Balancers to remove from your service configuration. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.service.configuration.modify(
                ctx, service_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.service.configuration.modify service_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_endpoint_service_configuration",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "PrivateDnsName": private_dns_name,
            "RemovePrivateDnsName": remove_private_dns_name,
            "AcceptanceRequired": acceptance_required,
            "AddNetworkLoadBalancerArns": add_network_load_balancer_arns,
            "RemoveNetworkLoadBalancerArns": remove_network_load_balancer_arns,
            "AddGatewayLoadBalancerArns": add_gateway_load_balancer_arns,
            "RemoveGatewayLoadBalancerArns": remove_gateway_load_balancer_arns,
        },
    )
