"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    vpc_id: str,
    service_name: str,
    dry_run: bool = None,
    vpc_endpoint_type: str = None,
    policy_document: str = None,
    route_table_ids: List = None,
    subnet_ids: List = None,
    security_group_ids: List = None,
    client_token: str = None,
    private_dns_enabled: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPC endpoint for a specified service. An endpoint enables you to create a private connection between your VPC and the service. The service may be provided by AWS, an AWS Marketplace Partner, or another AWS account. For more information, see VPC Endpoints in the Amazon Virtual Private Cloud User Guide. A gateway endpoint serves as a target for a route in your route table for traffic destined for the AWS service. You can specify an endpoint policy to attach to the endpoint, which will control access to the service from your VPC. You can also specify the VPC route tables that use the endpoint. An interface endpoint is a network interface in your subnet that serves as an endpoint for communicating with the specified service. You can specify the subnets in which to create an endpoint, and the security groups to associate with the endpoint network interface. A GatewayLoadBalancer endpoint is a network interface in your subnet that serves an endpoint for communicating with a Gateway Load Balancer that you've configured as a VPC endpoint service. Use DescribeVpcEndpointServices to get a list of supported services.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_type(str, optional): The type of endpoint. Default: Gateway. Defaults to None.
        vpc_id(str): The ID of the VPC in which the endpoint will be used.
        service_name(str): The service name. To get a list of available services, use the DescribeVpcEndpointServices request, or get the name from the service provider.
        policy_document(str, optional): (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. If this parameter is not specified, we attach a default policy that allows full access to the service. Defaults to None.
        route_table_ids(List, optional): (Gateway endpoint) One or more route table IDs. Defaults to None.
        subnet_ids(List, optional): (Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only. Defaults to None.
        security_group_ids(List, optional): (Interface endpoint) The ID of one or more security groups to associate with the endpoint network interface. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        private_dns_enabled(bool, optional): (Interface endpoint) Indicates whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, kinesis.us-east-1.amazonaws.com), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service. To use a private hosted zone, you must set the following VPC attributes to true: enableDnsHostnames and enableDnsSupport. Use ModifyVpcAttribute to set the VPC attributes. Default: true . Defaults to None.
        tag_specifications(List, optional): The tags to associate with the endpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.init.create(
                ctx, vpc_id=value, service_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.init.create vpc_id=value, service_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpc_endpoint",
        op_kwargs={
            "DryRun": dry_run,
            "VpcEndpointType": vpc_endpoint_type,
            "VpcId": vpc_id,
            "ServiceName": service_name,
            "PolicyDocument": policy_document,
            "RouteTableIds": route_table_ids,
            "SubnetIds": subnet_ids,
            "SecurityGroupIds": security_group_ids,
            "ClientToken": client_token,
            "PrivateDnsEnabled": private_dns_enabled,
            "TagSpecifications": tag_specifications,
        },
    )


async def delete_multiple(
    hub, ctx, vpc_endpoint_ids: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more specified VPC endpoints. You can delete any of the following types of VPC endpoints.    Gateway endpoint,   Gateway Load Balancer endpoint,   Interface endpoint   The following rules apply when you delete a VPC endpoint:   When you delete a gateway endpoint, we delete the endpoint routes in the route tables that are associated with the endpoint.   When you delete a Gateway Load Balancer endpoint, we delete the endpoint network interfaces.  You can only delete Gateway Load Balancer endpoints when the routes that are associated with the endpoint are deleted.   When you delete an interface endpoint, we delete the endpoint network interfaces.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_ids(List): One or more VPC endpoint IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.init.delete_multiple(
                ctx, vpc_endpoint_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.init.delete_multiple vpc_endpoint_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpc_endpoints",
        op_kwargs={"DryRun": dry_run, "VpcEndpointIds": vpc_endpoint_ids},
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    vpc_endpoint_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your VPC endpoints.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_ids(List, optional): One or more endpoint IDs. Defaults to None.
        filters(List, optional): One or more filters.    service-name - The name of the service.    vpc-id - The ID of the VPC in which the endpoint resides.    vpc-endpoint-id - The ID of the endpoint.    vpc-endpoint-state - The state of the endpoint (pendingAcceptance | pending | available | deleting | deleted | rejected | failed).    vpc-endpoint-type - The type of VPC endpoint (Interface | Gateway | GatewayLoadBalancer).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        max_results(int, optional): The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results. Constraint: If the value is greater than 1,000, we return only 1,000 items. Defaults to None.
        next_token(str, optional): The token for the next set of items to return. (You received this token from a prior call.). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_endpoints",
        op_kwargs={
            "DryRun": dry_run,
            "VpcEndpointIds": vpc_endpoint_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    vpc_endpoint_id: str,
    dry_run: bool = None,
    reset_policy: bool = None,
    policy_document: str = None,
    add_route_table_ids: List = None,
    remove_route_table_ids: List = None,
    add_subnet_ids: List = None,
    remove_subnet_ids: List = None,
    add_security_group_ids: List = None,
    remove_security_group_ids: List = None,
    private_dns_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies attributes of a specified VPC endpoint. The attributes that you can modify depend on the type of VPC endpoint (interface, gateway, or Gateway Load Balancer). For more information, see VPC Endpoints in the Amazon Virtual Private Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_endpoint_id(str): The ID of the endpoint.
        reset_policy(bool, optional): (Gateway endpoint) Specify true to reset the policy document to the default policy. The default policy allows full access to the service. Defaults to None.
        policy_document(str, optional): (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format. Defaults to None.
        add_route_table_ids(List, optional): (Gateway endpoint) One or more route tables IDs to associate with the endpoint. Defaults to None.
        remove_route_table_ids(List, optional): (Gateway endpoint) One or more route table IDs to disassociate from the endpoint. Defaults to None.
        add_subnet_ids(List, optional): (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet. Defaults to None.
        remove_subnet_ids(List, optional): (Interface endpoint) One or more subnets IDs in which to remove the endpoint. Defaults to None.
        add_security_group_ids(List, optional): (Interface endpoint) One or more security group IDs to associate with the network interface. Defaults to None.
        remove_security_group_ids(List, optional): (Interface endpoint) One or more security group IDs to disassociate from the network interface. Defaults to None.
        private_dns_enabled(bool, optional): (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.init.modify(ctx, vpc_endpoint_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.init.modify vpc_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_endpoint",
        op_kwargs={
            "DryRun": dry_run,
            "VpcEndpointId": vpc_endpoint_id,
            "ResetPolicy": reset_policy,
            "PolicyDocument": policy_document,
            "AddRouteTableIds": add_route_table_ids,
            "RemoveRouteTableIds": remove_route_table_ids,
            "AddSubnetIds": add_subnet_ids,
            "RemoveSubnetIds": remove_subnet_ids,
            "AddSecurityGroupIds": add_security_group_ids,
            "RemoveSecurityGroupIds": remove_security_group_ids,
            "PrivateDnsEnabled": private_dns_enabled,
        },
    )
