"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    connection_notification_arn: str,
    connection_events: List,
    dry_run: bool = None,
    service_id: str = None,
    vpc_endpoint_id: str = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A connection notification notifies you of specific endpoint events. You must create an SNS topic to receive notifications. For more information, see Create a Topic in the Amazon Simple Notification Service Developer Guide. You can create a connection notification for interface endpoints only.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str, optional): The ID of the endpoint service. Defaults to None.
        vpc_endpoint_id(str, optional): The ID of the endpoint. Defaults to None.
        connection_notification_arn(str): The ARN of the SNS topic for the notifications.
        connection_events(List): One or more endpoint events for which to receive notifications. Valid values are Accept, Connect, Delete, and Reject.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.notification.create(
                ctx, connection_notification_arn=value, connection_events=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.notification.create connection_notification_arn=value, connection_events=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_vpc_endpoint_connection_notification",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "VpcEndpointId": vpc_endpoint_id,
            "ConnectionNotificationArn": connection_notification_arn,
            "ConnectionEvents": connection_events,
            "ClientToken": client_token,
        },
    )


async def delete_multiple(
    hub, ctx, connection_notification_ids: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more VPC endpoint connection notifications.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        connection_notification_ids(List): One or more notification IDs.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.notification.delete_multiple(
                ctx, connection_notification_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.notification.delete_multiple connection_notification_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_vpc_endpoint_connection_notifications",
        op_kwargs={
            "DryRun": dry_run,
            "ConnectionNotificationIds": connection_notification_ids,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    connection_notification_id: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the connection notifications for VPC endpoints and VPC endpoint services.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        connection_notification_id(str, optional): The ID of the notification. Defaults to None.
        filters(List, optional): One or more filters.    connection-notification-arn - The ARN of the SNS topic for the notification.    connection-notification-id - The ID of the notification.    connection-notification-state - The state of the notification (Enabled | Disabled).    connection-notification-type - The type of notification (Topic).    service-id - The ID of the endpoint service.    vpc-endpoint-id - The ID of the VPC endpoint.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token to request the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.notification.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.notification.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_endpoint_connection_notifications",
        op_kwargs={
            "DryRun": dry_run,
            "ConnectionNotificationId": connection_notification_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    connection_notification_id: str,
    dry_run: bool = None,
    connection_notification_arn: str = None,
    connection_events: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a connection notification for VPC endpoint or VPC endpoint service. You can change the SNS topic for the notification, or the events for which to be notified.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        connection_notification_id(str): The ID of the notification.
        connection_notification_arn(str, optional): The ARN for the SNS topic for the notification. Defaults to None.
        connection_events(List, optional): One or more events for the endpoint. Valid values are Accept, Connect, Delete, and Reject. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.notification.modify(
                ctx, connection_notification_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.notification.modify connection_notification_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_endpoint_connection_notification",
        op_kwargs={
            "DryRun": dry_run,
            "ConnectionNotificationId": connection_notification_id,
            "ConnectionNotificationArn": connection_notification_arn,
            "ConnectionEvents": connection_events,
        },
    )
