"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, service_id: str, vpc_endpoint_ids: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts one or more interface VPC endpoint connection requests to your VPC endpoint service.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str): The ID of the VPC endpoint service.
        vpc_endpoint_ids(List): The IDs of one or more interface VPC endpoints.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.init.accept(
                ctx, service_id=value, vpc_endpoint_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.init.accept service_id=value, vpc_endpoint_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="accept_vpc_endpoint_connections",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "VpcEndpointIds": vpc_endpoint_ids,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the VPC endpoint connections to your VPC endpoint services, including any endpoints that are pending your acceptance.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): One or more filters.    service-id - The ID of the service.    vpc-endpoint-owner - The AWS account number of the owner of the endpoint.    vpc-endpoint-state - The state of the endpoint (pendingAcceptance | pending | available | deleting | deleted | rejected | failed).    vpc-endpoint-id - The ID of the endpoint.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return for the request in a single page. The remaining results of the initial request can be seen by sending another request with the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given a value larger than 1,000, only 1,000 results are returned. Defaults to None.
        next_token(str, optional): The token to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_endpoint_connections",
        op_kwargs={
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def reject(
    hub, ctx, service_id: str, vpc_endpoint_ids: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects one or more VPC endpoint connection requests to your VPC endpoint service.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        service_id(str): The ID of the service.
        vpc_endpoint_ids(List): The IDs of one or more VPC endpoints.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.endpoint.connection.init.reject(
                ctx, service_id=value, vpc_endpoint_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.endpoint.connection.init.reject service_id=value, vpc_endpoint_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reject_vpc_endpoint_connections",
        op_kwargs={
            "DryRun": dry_run,
            "ServiceId": service_id,
            "VpcEndpointIds": vpc_endpoint_ids,
        },
    )
