"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, filters: List = None, dry_run: bool = None, vpc_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the ClassicLink status of one or more VPCs.

    Args:
        filters(List, optional): One or more filters.    is-classic-link-enabled - Whether the VPC is enabled for ClassicLink (true | false).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_ids(List, optional): One or more VPCs for which you want to describe the ClassicLink status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_classic_link",
        op_kwargs={"Filters": filters, "DryRun": dry_run, "VpcIds": vpc_ids},
    )


async def disable(hub, ctx, vpc_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_id(str): The ID of the VPC.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.init.disable(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.init.disable vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_vpc_classic_link",
        op_kwargs={"DryRun": dry_run, "VpcId": vpc_id},
    )


async def enable(hub, ctx, vpc_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Enables a VPC for ClassicLink. You can then link EC2-Classic instances to your ClassicLink-enabled VPC to allow communication over private IP addresses. You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing routes for address ranges within the 10.0.0.0/8 IP address range, excluding local routes for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        vpc_id(str): The ID of the VPC.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.init.enable(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.init.enable vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_vpc_classic_link",
        op_kwargs={"DryRun": dry_run, "VpcId": vpc_id},
    )
