"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, max_results: int = None, next_token: str = None, vpc_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the ClassicLink DNS support status of one or more VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide.

    Args:
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        vpc_ids(List, optional): One or more VPC IDs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.dns_support.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.dns_support.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_classic_link_dns_support",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "VpcIds": vpc_ids,
        },
    )


async def disable(hub, ctx, vpc_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames resolve to public IP addresses when addressed between a linked EC2-Classic instance and instances in the VPC to which it's linked. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.

    Args:
        vpc_id(str, optional): The ID of the VPC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.dns_support.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.dns_support.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_vpc_classic_link_dns_support",
        op_kwargs={"VpcId": vpc_id},
    )


async def enable(hub, ctx, vpc_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Enables a VPC to support DNS hostname resolution for ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private IP address when addressed from an instance in the VPC to which it's linked. Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when addressed from a linked EC2-Classic instance. For more information, see ClassicLink in the Amazon Elastic Compute Cloud User Guide. You must specify a VPC ID in the request.

    Args:
        vpc_id(str, optional): The ID of the VPC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.classic_link.dns_support.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.classic_link.dns_support.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_vpc_classic_link_dns_support",
        op_kwargs={"VpcId": vpc_id},
    )
