"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    vpc_id: str,
    amazon_provided_ipv6_cidr_block: bool = None,
    cidr_block: str = None,
    ipv6_cidr_block_network_border_group: str = None,
    ipv6_pool: str = None,
    ipv6_cidr_block: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you provisioned through bring your own IP addresses (BYOIP). The IPv6 CIDR block size is fixed at /56. You must specify one of the following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block. For more information about associating CIDR blocks with your VPC and applicable restrictions, see VPC and subnet sizing in the Amazon Virtual Private Cloud User Guide.

    Args:
        amazon_provided_ipv6_cidr_block(bool, optional): Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IPv6 addresses, or the size of the CIDR block. Defaults to None.
        cidr_block(str, optional): An IPv4 CIDR block to associate with the VPC. Defaults to None.
        vpc_id(str): The ID of the VPC.
        ipv6_cidr_block_network_border_group(str, optional): The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.  You must set AmazonProvidedIpv6CidrBlock to true to use this parameter.  You can have one IPv6 CIDR block association per network border group. Defaults to None.
        ipv6_pool(str, optional): The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block. Defaults to None.
        ipv6_cidr_block(str, optional): An IPv6 CIDR block from the IPv6 address pool. You must also specify Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.cidr_block.associate(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.cidr_block.associate vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_vpc_cidr_block",
        op_kwargs={
            "AmazonProvidedIpv6CidrBlock": amazon_provided_ipv6_cidr_block,
            "CidrBlock": cidr_block,
            "VpcId": vpc_id,
            "Ipv6CidrBlockNetworkBorderGroup": ipv6_cidr_block_network_border_group,
            "Ipv6Pool": ipv6_pool,
            "Ipv6CidrBlock": ipv6_cidr_block,
        },
    )


async def disassociate(hub, ctx, association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its association ID. You can get the association ID by using DescribeVpcs. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.  You cannot disassociate the CIDR block with which you originally created the VPC (the primary CIDR block).

    Args:
        association_id(str): The association ID for the CIDR block.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.cidr_block.disassociate(ctx, association_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.cidr_block.disassociate association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_vpc_cidr_block",
        op_kwargs={"AssociationId": association_id},
    )
