"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, attribute: str, vpc_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified attribute of the specified VPC. You can specify only one attribute at a time.

    Args:
        attribute(str): The VPC attribute.
        vpc_id(str): The ID of the VPC.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.attribute.describe(ctx, attribute=value, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.attribute.describe attribute=value, vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_vpc_attribute",
        op_kwargs={"Attribute": attribute, "VpcId": vpc_id, "DryRun": dry_run},
    )


async def modify(
    hub,
    ctx,
    vpc_id: str,
    enable_dns_hostnames: Dict = None,
    enable_dns_support: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Modifies the specified attribute of the specified VPC.

    Args:
        enable_dns_hostnames(Dict, optional): Indicates whether the instances launched in the VPC get DNS hostnames. If enabled, instances in the VPC get DNS hostnames; otherwise, they do not. You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. You can only enable DNS hostnames if you've enabled DNS support. Defaults to None.
        enable_dns_support(Dict, optional): Indicates whether the DNS resolution is supported for the VPC. If enabled, queries to the Amazon provided DNS server at the 169.254.169.253 IP address, or the reserved IP address at the base of the VPC network range "plus two" succeed. If disabled, the Amazon provided DNS service in the VPC that resolves public DNS hostnames to IP addresses is not enabled. You cannot modify the DNS resolution and DNS hostnames attributes in the same request. Use separate requests for each attribute. Defaults to None.
        vpc_id(str): The ID of the VPC.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vpc.attribute.modify(ctx, vpc_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vpc.attribute.modify vpc_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_vpc_attribute",
        op_kwargs={
            "EnableDnsHostnames": enable_dns_hostnames,
            "EnableDnsSupport": enable_dns_support,
            "VpcId": vpc_id,
        },
    )
