"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, attribute: str, volume_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified attribute of the specified volume. You can specify only one attribute at a time. For more information about EBS volumes, see Amazon EBS volumes in the Amazon Elastic Compute Cloud User Guide.

    Args:
        attribute(str): The attribute of the volume. This parameter is required.
        volume_id(str): The ID of the volume.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.volume.attribute.describe(
                ctx, attribute=value, volume_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.volume.attribute.describe attribute=value, volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_volume_attribute",
        op_kwargs={"Attribute": attribute, "VolumeId": volume_id, "DryRun": dry_run},
    )


async def modify(
    hub, ctx, volume_id: str, auto_enable_io: Dict = None, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Modifies a volume attribute. By default, all I/O operations for the volume are suspended when the data on the volume is determined to be potentially inconsistent, to prevent undetectable, latent data corruption. The I/O access to the volume can be resumed by first enabling I/O access and then checking the data consistency on your volume. You can change the default behavior to resume I/O operations. We recommend that you change this only for boot volumes or for volumes that are stateless or disposable.

    Args:
        auto_enable_io(Dict, optional): Indicates whether the volume should be auto-enabled for I/O operations. Defaults to None.
        volume_id(str): The ID of the volume.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.volume.attribute.modify(ctx, volume_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.volume.attribute.modify volume_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_volume_attribute",
        op_kwargs={
            "AutoEnableIO": auto_enable_io,
            "VolumeId": volume_id,
            "DryRun": dry_run,
        },
    )
