"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disable(
    hub, ctx, gateway_id: str, route_table_id: str, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Disables a virtual private gateway (VGW) from propagating routes to a specified route table of a VPC.

    Args:
        gateway_id(str): The ID of the virtual private gateway.
        route_table_id(str): The ID of the route table.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vgw_route_propagation.disable(
                ctx, gateway_id=value, route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vgw_route_propagation.disable gateway_id=value, route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_vgw_route_propagation",
        op_kwargs={
            "GatewayId": gateway_id,
            "RouteTableId": route_table_id,
            "DryRun": dry_run,
        },
    )


async def enable(
    hub, ctx, gateway_id: str, route_table_id: str, dry_run: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Enables a virtual private gateway (VGW) to propagate routes to the specified route table of a VPC.

    Args:
        gateway_id(str): The ID of the virtual private gateway that is attached to a VPC. The virtual private gateway must be attached to the same VPC that the routing tables are associated with. .
        route_table_id(str): The ID of the route table. The routing table must be associated with the same VPC that the virtual private gateway is attached to. .
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.vgw_route_propagation.enable(
                ctx, gateway_id=value, route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.vgw_route_propagation.enable gateway_id=value, route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_vgw_route_propagation",
        op_kwargs={
            "GatewayId": gateway_id,
            "RouteTableId": route_table_id,
            "DryRun": dry_run,
        },
    )
