"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    branch_interface_id: str,
    trunk_interface_id: str,
    vlan_id: int = None,
    gre_key: int = None,
    client_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a branch network interface with a trunk network interface. Before you create the association, run the create-network-interface command and set --interface-type to trunk. You must also create a network interface for each branch network interface that you want to associate with the trunk network interface. For more information, see  Network interface trunking in the Amazon Elastic Compute Cloud User Guide.

    Args:
        branch_interface_id(str): The ID of the branch network interface.
        trunk_interface_id(str): The ID of the trunk network interface.
        vlan_id(int, optional): The ID of the VLAN. This applies to the VLAN protocol. Defaults to None.
        gre_key(int, optional): The application key. This applies to the GRE protocol. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.trunk_interface.init.associate(
                ctx, branch_interface_id=value, trunk_interface_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.trunk_interface.init.associate branch_interface_id=value, trunk_interface_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_trunk_interface",
        op_kwargs={
            "BranchInterfaceId": branch_interface_id,
            "TrunkInterfaceId": trunk_interface_id,
            "VlanId": vlan_id,
            "GreKey": gre_key,
            "ClientToken": client_token,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub, ctx, association_id: str, client_token: str = None, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes an association between a branch network interface with a trunk network interface.

    Args:
        association_id(str): The ID ofthe association.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.trunk_interface.init.disassociate(ctx, association_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.trunk_interface.init.disassociate association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_trunk_interface",
        op_kwargs={
            "AssociationId": association_id,
            "ClientToken": client_token,
            "DryRun": dry_run,
        },
    )
