"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use RejectTransitGatewayVpcAttachment to reject a VPC attachment request.

    Args:
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.accept(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.accept transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="accept_transit_gateway_vpc_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def create(
    hub,
    ctx,
    transit_gateway_id: str,
    vpc_id: str,
    subnet_ids: List,
    options: Dict = None,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches the specified VPC to the specified transit gateway. If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR range is not propagated to the default propagation route table. To send VPC traffic to an attached transit gateway, add a route to the VPC route table using CreateRoute.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        vpc_id(str): The ID of the VPC.
        subnet_ids(List): The IDs of one or more subnets. You can specify only one subnet per Availability Zone. You must specify at least one subnet, but we recommend that you specify two subnets for better availability. The transit gateway uses one IP address from each specified subnet.
        options(Dict, optional): The VPC attachment options. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the VPC attachment. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.create(
                ctx, transit_gateway_id=value, vpc_id=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.create transit_gateway_id=value, vpc_id=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_vpc_attachment",
        op_kwargs={
            "TransitGatewayId": transit_gateway_id,
            "VpcId": vpc_id,
            "SubnetIds": subnet_ids,
            "Options": options,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified VPC attachment.

    Args:
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.delete(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.delete transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_vpc_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_attachment_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more VPC attachments. By default, all VPC attachments are described. Alternatively, you can filter the results.

    Args:
        transit_gateway_attachment_ids(List, optional): The IDs of the attachments. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    state - The state of the attachment. Valid values are available | deleted | deleting | failed | failing | initiatingRequest | modifying | pendingAcceptance | pending | rollingBack | rejected | rejecting.    transit-gateway-attachment-id - The ID of the attachment.    transit-gateway-id - The ID of the transit gateway.    vpc-id - The ID of the VPC.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_vpc_attachments",
        op_kwargs={
            "TransitGatewayAttachmentIds": transit_gateway_attachment_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    transit_gateway_attachment_id: str,
    add_subnet_ids: List = None,
    remove_subnet_ids: List = None,
    options: Dict = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified VPC attachment.

    Args:
        transit_gateway_attachment_id(str): The ID of the attachment.
        add_subnet_ids(List, optional): The IDs of one or more subnets to add. You can specify at most one subnet per Availability Zone. Defaults to None.
        remove_subnet_ids(List, optional): The IDs of one or more subnets to remove. Defaults to None.
        options(Dict, optional): The new VPC attachment options.  You cannot modify the IPv6 options. . Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.modify(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.modify transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_transit_gateway_vpc_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "AddSubnetIds": add_subnet_ids,
            "RemoveSubnetIds": remove_subnet_ids,
            "Options": options,
            "DryRun": dry_run,
        },
    )


async def reject(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects a request to attach a VPC to a transit gateway. The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC attachment requests. Use AcceptTransitGatewayVpcAttachment to accept a VPC attachment request.

    Args:
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.vpc_attachment.reject(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.vpc_attachment.reject transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reject_transit_gateway_vpc_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )
