"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def disable(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disables the specified resource attachment from propagating routes to the specified propagation route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the propagation route table.
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.propagation.disable(
                ctx, transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.propagation.disable transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disable_transit_gateway_route_table_propagation",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def enable(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables the specified attachment to propagate routes to the specified propagation route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the propagation route table.
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.propagation.enable(
                ctx, transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.propagation.enable transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="enable_transit_gateway_route_table_propagation",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def get_all(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the route table propagations for the specified transit gateway route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        filters(List, optional): One or more filters. The possible values are:    resource-id - The ID of the resource.    resource-type - The resource type. Valid values are vpc | vpn | direct-connect-gateway | peering | connect.    transit-gateway-attachment-id - The ID of the attachment.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.propagation.get_all(
                ctx, transit_gateway_route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.propagation.get_all transit_gateway_route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_transit_gateway_route_table_propagations",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
