"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified attachment with the specified transit gateway route table. You can associate only one route table with an attachment.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.init.associate(
                ctx, transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.init.associate transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_transit_gateway_route_table",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def create(
    hub,
    ctx,
    transit_gateway_id: str,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a route table for the specified transit gateway.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        tag_specifications(List, optional): The tags to apply to the transit gateway route table. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.init.create(
                ctx, transit_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.init.create transit_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_route_table",
        op_kwargs={
            "TransitGatewayId": transit_gateway_id,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_route_table_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified transit gateway route table. You must disassociate the route table from any transit gateway route tables before you can delete it.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.init.delete(
                ctx, transit_gateway_route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.init.delete transit_gateway_route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_route_table",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_route_table_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more transit gateway route tables. By default, all transit gateway route tables are described. Alternatively, you can filter the results.

    Args:
        transit_gateway_route_table_ids(List, optional): The IDs of the transit gateway route tables. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    default-association-route-table - Indicates whether this is the default association route table for the transit gateway (true | false).    default-propagation-route-table - Indicates whether this is the default propagation route table for the transit gateway (true | false).    state - The state of the route table (available | deleting | deleted | pending).    transit-gateway-id - The ID of the transit gateway.    transit-gateway-route-table-id - The ID of the transit gateway route table.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_route_tables",
        op_kwargs={
            "TransitGatewayRouteTableIds": transit_gateway_route_table_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a resource attachment from a transit gateway route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        transit_gateway_attachment_id(str): The ID of the attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.table.init.disassociate(
                ctx, transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.table.init.disassociate transit_gateway_route_table_id=value, transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_transit_gateway_route_table",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )
