"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    destination_cidr_block: str,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str = None,
    blackhole: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a static route for the specified transit gateway route table.

    Args:
        destination_cidr_block(str): The CIDR range used for destination matches. Routing decisions are based on the most specific match.
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        transit_gateway_attachment_id(str, optional): The ID of the attachment. Defaults to None.
        blackhole(bool, optional): Indicates whether to drop traffic that matches this route. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.init.create(
                ctx, destination_cidr_block=value, transit_gateway_route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.init.create destination_cidr_block=value, transit_gateway_route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "Blackhole": blackhole,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    destination_cidr_block: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified route from the specified transit gateway route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        destination_cidr_block(str): The CIDR range for the route. This must match the CIDR for the route exactly.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.init.delete(
                ctx, transit_gateway_route_table_id=value, destination_cidr_block=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.init.delete transit_gateway_route_table_id=value, destination_cidr_block=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_route",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "DestinationCidrBlock": destination_cidr_block,
            "DryRun": dry_run,
        },
    )


async def export(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    s3_bucket: str,
    filters: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports routes from the specified transit gateway route table to the specified S3 bucket. By default, all routes are exported. Alternatively, you can filter by CIDR range. The routes are saved to the specified bucket in a JSON file. For more information, see Export Route Tables to Amazon S3 in Transit Gateways.

    Args:
        transit_gateway_route_table_id(str): The ID of the route table.
        filters(List, optional): One or more filters. The possible values are:    attachment.transit-gateway-attachment-id - The id of the transit gateway attachment.    attachment.resource-id - The resource id of the transit gateway attachment.    route-search.exact-match - The exact match of the specified filter.    route-search.longest-prefix-match - The longest prefix that matches the route.    route-search.subnet-of-match - The routes with a subnet that match the specified CIDR filter.    route-search.supernet-of-match - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.    state - The state of the route (active | blackhole).    transit-gateway-route-destination-cidr-block - The CIDR range.    type - The type of route (propagated | static).  . Defaults to None.
        s3_bucket(str): The name of the S3 bucket.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.init.export(
                ctx, transit_gateway_route_table_id=value, s3_bucket=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.init.export transit_gateway_route_table_id=value, s3_bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="export_transit_gateway_routes",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "Filters": filters,
            "S3Bucket": s3_bucket,
            "DryRun": dry_run,
        },
    )


async def replace(
    hub,
    ctx,
    destination_cidr_block: str,
    transit_gateway_route_table_id: str,
    transit_gateway_attachment_id: str = None,
    blackhole: bool = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Replaces the specified route in the specified transit gateway route table.

    Args:
        destination_cidr_block(str): The CIDR range used for the destination match. Routing decisions are based on the most specific match.
        transit_gateway_route_table_id(str): The ID of the route table.
        transit_gateway_attachment_id(str, optional): The ID of the attachment. Defaults to None.
        blackhole(bool, optional): Indicates whether traffic matching this route is to be dropped. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.init.replace(
                ctx, destination_cidr_block=value, transit_gateway_route_table_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.init.replace destination_cidr_block=value, transit_gateway_route_table_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="replace_transit_gateway_route",
        op_kwargs={
            "DestinationCidrBlock": destination_cidr_block,
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "Blackhole": blackhole,
            "DryRun": dry_run,
        },
    )


async def search(
    hub,
    ctx,
    transit_gateway_route_table_id: str,
    filters: List,
    max_results: int = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches for routes in the specified transit gateway route table.

    Args:
        transit_gateway_route_table_id(str): The ID of the transit gateway route table.
        filters(List): One or more filters. The possible values are:    attachment.transit-gateway-attachment-id- The id of the transit gateway attachment.    attachment.resource-id - The resource id of the transit gateway attachment.    attachment.resource-type - The attachment resource type. Valid values are vpc | vpn | direct-connect-gateway | peering | connect.    prefix-list-id - The ID of the prefix list.    route-search.exact-match - The exact match of the specified filter.    route-search.longest-prefix-match - The longest prefix that matches the route.    route-search.subnet-of-match - The routes with a subnet that match the specified CIDR filter.    route-search.supernet-of-match - The routes with a CIDR that encompass the CIDR filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.    state - The state of the route (active | blackhole).    type - The type of route (propagated | static).  .
        max_results(int, optional): The maximum number of routes to return. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.route.init.search(
                ctx, transit_gateway_route_table_id=value, filters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.route.init.search transit_gateway_route_table_id=value, filters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="search_transit_gateway_routes",
        op_kwargs={
            "TransitGatewayRouteTableId": transit_gateway_route_table_id,
            "Filters": filters,
            "MaxResults": max_results,
            "DryRun": dry_run,
        },
    )
