"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a transit gateway peering attachment request. The peering attachment must be in the pendingAcceptance state.

    Args:
        transit_gateway_attachment_id(str): The ID of the transit gateway attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.peering_attachment.accept(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.peering_attachment.accept transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="accept_transit_gateway_peering_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def create(
    hub,
    ctx,
    transit_gateway_id: str,
    peer_transit_gateway_id: str,
    peer_account_id: str,
    peer_region: str,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests a transit gateway peering attachment between the specified transit gateway (requester) and a peer transit gateway (accepter). The transit gateways must be in different Regions. The peer transit gateway can be in your account or a different AWS account.  After you create the peering attachment, the owner of the accepter transit gateway must accept the attachment request.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        peer_transit_gateway_id(str): The ID of the peer transit gateway with which to create the peering attachment.
        peer_account_id(str): The AWS account ID of the owner of the peer transit gateway.
        peer_region(str): The Region where the peer transit gateway is located.
        tag_specifications(List, optional): The tags to apply to the transit gateway peering attachment. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.peering_attachment.create(
                ctx,
                transit_gateway_id=value,
                peer_transit_gateway_id=value,
                peer_account_id=value,
                peer_region=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.peering_attachment.create transit_gateway_id=value, peer_transit_gateway_id=value, peer_account_id=value, peer_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_peering_attachment",
        op_kwargs={
            "TransitGatewayId": transit_gateway_id,
            "PeerTransitGatewayId": peer_transit_gateway_id,
            "PeerAccountId": peer_account_id,
            "PeerRegion": peer_region,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a transit gateway peering attachment.

    Args:
        transit_gateway_attachment_id(str): The ID of the transit gateway peering attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.peering_attachment.delete(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.peering_attachment.delete transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_peering_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_attachment_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your transit gateway peering attachments.

    Args:
        transit_gateway_attachment_ids(List, optional): One or more IDs of the transit gateway peering attachments. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    transit-gateway-attachment-id - The ID of the transit gateway attachment.    local-owner-id - The ID of your AWS account.    remote-owner-id - The ID of the AWS account in the remote Region that owns the transit gateway.    state - The state of the peering attachment. Valid values are available | deleted | deleting | failed | failing | initiatingRequest | modifying | pendingAcceptance | pending | rollingBack | rejected | rejecting).    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources that have a tag with a specific key, regardless of the tag value.    transit-gateway-id - The ID of the transit gateway.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.peering_attachment.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.peering_attachment.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_peering_attachments",
        op_kwargs={
            "TransitGatewayAttachmentIds": transit_gateway_attachment_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def reject(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects a transit gateway peering attachment request.

    Args:
        transit_gateway_attachment_id(str): The ID of the transit gateway peering attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.peering_attachment.reject(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.peering_attachment.reject transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reject_transit_gateway_peering_attachment",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )
