"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    group_ip_address: str = None,
    network_interface_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deregisters the specified sources (network interfaces) from the transit gateway multicast group.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        group_ip_address(str, optional): The IP address assigned to the transit gateway multicast group. Defaults to None.
        network_interface_ids(List, optional): The IDs of the group sources' network interfaces. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.group.source.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.group.source.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="deregister_transit_gateway_multicast_group_sources",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "GroupIpAddress": group_ip_address,
            "NetworkInterfaceIds": network_interface_ids,
            "DryRun": dry_run,
        },
    )


async def register(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    group_ip_address: str = None,
    network_interface_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers sources (network interfaces) with the specified transit gateway multicast group. A multicast source is a network interface attached to a supported instance that sends multicast traffic. For information about supported instances, see Multicast Considerations in Amazon VPC Transit Gateways. After you add the source, use SearchTransitGatewayMulticastGroups to verify that the source was added to the multicast group.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        group_ip_address(str, optional): The IP address assigned to the transit gateway multicast group. Defaults to None.
        network_interface_ids(List, optional): The group sources' network interface IDs to register with the transit gateway multicast group. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.group.source.register(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.group.source.register
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="register_transit_gateway_multicast_group_sources",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "GroupIpAddress": group_ip_address,
            "NetworkInterfaceIds": network_interface_ids,
            "DryRun": dry_run,
        },
    )
