"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    transit_gateway_attachment_id: str = None,
    subnet_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified subnets and transit gateway attachments with the specified transit gateway multicast domain. The transit gateway attachment must be in the available state before you can add a resource. Use DescribeTransitGatewayAttachments to see the state of the attachment.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        transit_gateway_attachment_id(str, optional): The ID of the transit gateway attachment to associate with the transit gateway multicast domain. Defaults to None.
        subnet_ids(List, optional): The IDs of the subnets to associate with the transit gateway multicast domain. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.init.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.init.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_transit_gateway_multicast_domain",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "SubnetIds": subnet_ids,
            "DryRun": dry_run,
        },
    )


async def create(
    hub,
    ctx,
    transit_gateway_id: str,
    options: Dict = None,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a multicast domain using the specified transit gateway. The transit gateway must be in the available state before you create a domain. Use DescribeTransitGateways to see the state of transit gateway.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        options(Dict, optional): The options for the transit gateway multicast domain. Defaults to None.
        tag_specifications(List, optional): The tags for the transit gateway multicast domain. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.init.create(
                ctx, transit_gateway_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.init.create transit_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_multicast_domain",
        op_kwargs={
            "TransitGatewayId": transit_gateway_id,
            "Options": options,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_multicast_domain_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified transit gateway multicast domain.

    Args:
        transit_gateway_multicast_domain_id(str): The ID of the transit gateway multicast domain.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.init.delete(
                ctx, transit_gateway_multicast_domain_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.init.delete transit_gateway_multicast_domain_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_multicast_domain",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_multicast_domain_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more transit gateway multicast domains.

    Args:
        transit_gateway_multicast_domain_ids(List, optional): The ID of the transit gateway multicast domain. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    state - The state of the transit gateway multicast domain. Valid values are pending | available | deleting | deleted.    transit-gateway-id - The ID of the transit gateway.    transit-gateway-multicast-domain-id - The ID of the transit gateway multicast domain.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_multicast_domains",
        op_kwargs={
            "TransitGatewayMulticastDomainIds": transit_gateway_multicast_domain_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def disassociate(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    transit_gateway_attachment_id: str = None,
    subnet_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified subnets from the transit gateway multicast domain.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        transit_gateway_attachment_id(str, optional): The ID of the attachment. Defaults to None.
        subnet_ids(List, optional): The IDs of the subnets;. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.init.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.init.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_transit_gateway_multicast_domain",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "SubnetIds": subnet_ids,
            "DryRun": dry_run,
        },
    )
