"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    transit_gateway_attachment_id: str = None,
    subnet_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a request to associate subnets with a transit gateway multicast domain.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        transit_gateway_attachment_id(str, optional): The ID of the transit gateway attachment. Defaults to None.
        subnet_ids(List, optional): The IDs of the subnets to associate with the transit gateway multicast domain. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.association.accept(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.association.accept
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="accept_transit_gateway_multicast_domain_associations",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "SubnetIds": subnet_ids,
            "DryRun": dry_run,
        },
    )


async def get_all(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the associations for the transit gateway multicast domain.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    resource-id - The ID of the resource.    resource-type - The type of resource. The valid value is: vpc.    state - The state of the subnet association. Valid values are associated | associating | disassociated | disassociating.    subnet-id - The ID of the subnet.    transit-gateway-attachment-id - The id of the transit gateway attachment.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.association.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.association.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_transit_gateway_multicast_domain_associations",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def reject(
    hub,
    ctx,
    transit_gateway_multicast_domain_id: str = None,
    transit_gateway_attachment_id: str = None,
    subnet_ids: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects a request to associate cross-account subnets with a transit gateway multicast domain.

    Args:
        transit_gateway_multicast_domain_id(str, optional): The ID of the transit gateway multicast domain. Defaults to None.
        transit_gateway_attachment_id(str, optional): The ID of the transit gateway attachment. Defaults to None.
        subnet_ids(List, optional): The IDs of the subnets to associate with the transit gateway multicast domain. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.multicast.domain.association.reject(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.multicast.domain.association.reject
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="reject_transit_gateway_multicast_domain_associations",
        op_kwargs={
            "TransitGatewayMulticastDomainId": transit_gateway_multicast_domain_id,
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "SubnetIds": subnet_ids,
            "DryRun": dry_run,
        },
    )
