"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    description: str = None,
    options: Dict = None,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a transit gateway. You can use a transit gateway to interconnect your virtual private clouds (VPC) and on-premises networks. After the transit gateway enters the available state, you can attach your VPCs and VPN connections to the transit gateway. To attach your VPCs, use CreateTransitGatewayVpcAttachment. To attach a VPN connection, use CreateCustomerGateway to create a customer gateway and specify the ID of the customer gateway and the ID of the transit gateway in a call to CreateVpnConnection. When you create a transit gateway, we create a default transit gateway route table and use it as the default association route table and the default propagation route table. You can use CreateTransitGatewayRouteTable to create additional transit gateway route tables. If you disable automatic route propagation, we do not create a default transit gateway route table. You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a resource attachment to a transit gateway route table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable to associate a resource attachment with a transit gateway route table.

    Args:
        description(str, optional): A description of the transit gateway. Defaults to None.
        options(Dict, optional): The transit gateway options. Defaults to None.
        tag_specifications(List, optional): The tags to apply to the transit gateway. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway",
        op_kwargs={
            "Description": description,
            "Options": options,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(hub, ctx, transit_gateway_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified transit gateway.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.init.delete(ctx, transit_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.init.delete transit_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway",
        op_kwargs={"TransitGatewayId": transit_gateway_id, "DryRun": dry_run},
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more transit gateways. By default, all transit gateways are described. Alternatively, you can filter the results.

    Args:
        transit_gateway_ids(List, optional): The IDs of the transit gateways. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    options.propagation-default-route-table-id - The ID of the default propagation route table.    options.amazon-side-asn - The private ASN for the Amazon side of a BGP session.    options.association-default-route-table-id - The ID of the default association route table.    options.auto-accept-shared-attachments - Indicates whether there is automatic acceptance of attachment requests (enable | disable).    options.default-route-table-association - Indicates whether resource attachments are automatically associated with the default association route table (enable | disable).    options.default-route-table-propagation - Indicates whether resource attachments automatically propagate routes to the default propagation route table (enable | disable).    options.dns-support - Indicates whether DNS support is enabled (enable | disable).    options.vpn-ecmp-support - Indicates whether Equal Cost Multipath Protocol support is enabled (enable | disable).    owner-id - The ID of the AWS account that owns the transit gateway.    state - The state of the transit gateway (available | deleted | deleting | modifying | pending).    transit-gateway-id - The ID of the transit gateway.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateways",
        op_kwargs={
            "TransitGatewayIds": transit_gateway_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    transit_gateway_id: str,
    description: str = None,
    options: Dict = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified transit gateway. When you modify a transit gateway, the modified options are applied to new transit gateway attachments only. Your existing transit gateway attachments are not modified.

    Args:
        transit_gateway_id(str): The ID of the transit gateway.
        description(str, optional): The description for the transit gateway. Defaults to None.
        options(Dict, optional): The options to modify. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.init.modify(ctx, transit_gateway_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.init.modify transit_gateway_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_transit_gateway",
        op_kwargs={
            "TransitGatewayId": transit_gateway_id,
            "Description": description,
            "Options": options,
            "DryRun": dry_run,
        },
    )
