"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    transit_gateway_attachment_id: str,
    peer_address: str,
    inside_cidr_blocks: List,
    transit_gateway_address: str = None,
    bgp_options: Dict = None,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Connect peer for a specified transit gateway Connect attachment between a transit gateway and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6). For more information, see Connect peers in the Transit Gateways Guide.

    Args:
        transit_gateway_attachment_id(str): The ID of the Connect attachment.
        transit_gateway_address(str, optional): The peer IP address (GRE outer IP address) on the transit gateway side of the Connect peer, which must be specified from a transit gateway CIDR block. If not specified, Amazon automatically assigns the first available IP address from the transit gateway CIDR block. Defaults to None.
        peer_address(str): The peer IP address (GRE outer IP address) on the appliance side of the Connect peer.
        bgp_options(Dict, optional): The BGP options for the Connect peer. Defaults to None.
        inside_cidr_blocks(List): The range of inside IP addresses that are used for BGP peering. You must specify a size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address from the range must be configured on the appliance as the BGP IP address. You can also optionally specify a size /125 IPv6 CIDR block from the fd00::/8 range.
        tag_specifications(List, optional): The tags to apply to the Connect peer. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.peer.create(
                ctx,
                transit_gateway_attachment_id=value,
                peer_address=value,
                inside_cidr_blocks=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.peer.create transit_gateway_attachment_id=value, peer_address=value, inside_cidr_blocks=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_connect_peer",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "TransitGatewayAddress": transit_gateway_address,
            "PeerAddress": peer_address,
            "BgpOptions": bgp_options,
            "InsideCidrBlocks": inside_cidr_blocks,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_connect_peer_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Connect peer.

    Args:
        transit_gateway_connect_peer_id(str): The ID of the Connect peer.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.peer.delete(
                ctx, transit_gateway_connect_peer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.peer.delete transit_gateway_connect_peer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_connect_peer",
        op_kwargs={
            "TransitGatewayConnectPeerId": transit_gateway_connect_peer_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_connect_peer_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more Connect peers.

    Args:
        transit_gateway_connect_peer_ids(List, optional): The IDs of the Connect peers. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    state - The state of the Connect peer (pending | available | deleting | deleted).    transit-gateway-attachment-id - The ID of the attachment.    transit-gateway-connect-peer-id - The ID of the Connect peer.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.peer.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.peer.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_connect_peers",
        op_kwargs={
            "TransitGatewayConnectPeerIds": transit_gateway_connect_peer_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
