"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    transport_transit_gateway_attachment_id: str,
    options: Dict,
    tag_specifications: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Connect attachment from a specified transit gateway attachment. A Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a transit gateway and an appliance. A Connect attachment uses an existing VPC or AWS Direct Connect attachment as the underlying transport mechanism.

    Args:
        transport_transit_gateway_attachment_id(str): The ID of the transit gateway attachment. You can specify a VPC attachment or a AWS Direct Connect attachment.
        options(Dict): The Connect attachment options.
        tag_specifications(List, optional): The tags to apply to the Connect attachment. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.init.create(
                ctx, transport_transit_gateway_attachment_id=value, options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.init.create transport_transit_gateway_attachment_id=value, options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_transit_gateway_connect",
        op_kwargs={
            "TransportTransitGatewayAttachmentId": transport_transit_gateway_attachment_id,
            "Options": options,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, transit_gateway_attachment_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Connect attachment. You must first delete any Connect peers for the attachment.

    Args:
        transit_gateway_attachment_id(str): The ID of the Connect attachment.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.init.delete(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.init.delete transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_transit_gateway_connect",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    transit_gateway_attachment_ids: List = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more Connect attachments.

    Args:
        transit_gateway_attachment_ids(List, optional): The IDs of the attachments. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    options.protocol - The tunnel protocol (gre).    state - The state of the attachment (initiating | initiatingRequest | pendingAcceptance | rollingBack | pending | available | modifying | deleting | deleted | failed | rejected | rejecting | failing).    transit-gateway-attachment-id - The ID of the Connect attachment.    transit-gateway-id - The ID of the transit gateway.    transport-transit-gateway-attachment-id - The ID of the transit gateway attachment from which the Connect attachment was created.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.connect.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.connect.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_transit_gateway_connects",
        op_kwargs={
            "TransitGatewayAttachmentIds": transit_gateway_attachment_ids,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
