"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    transit_gateway_attachment_id: str,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the route tables to which the specified resource attachment propagates routes.

    Args:
        transit_gateway_attachment_id(str): The ID of the attachment.
        filters(List, optional): One or more filters. The possible values are:    transit-gateway-route-table-id - The ID of the transit gateway route table.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.transit_gateway.attachment.propagation.get_all(
                ctx, transit_gateway_attachment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.transit_gateway.attachment.propagation.get_all transit_gateway_attachment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_transit_gateway_attachment_propagations",
        op_kwargs={
            "TransitGatewayAttachmentId": transit_gateway_attachment_id,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DryRun": dry_run,
        },
    )
