"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    network_interface_id: str = None,
    network_load_balancer_arn: str = None,
    description: str = None,
    tag_specifications: List = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a target for your Traffic Mirror session. A Traffic Mirror target is the destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC peering or a transit gateway. A Traffic Mirror target can be a network interface, or a Network Load Balancer. To use the target in a Traffic Mirror session, use CreateTrafficMirrorSession.

    Args:
        network_interface_id(str, optional): The network interface ID that is associated with the target. Defaults to None.
        network_load_balancer_arn(str, optional): The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target. Defaults to None.
        description(str, optional): The description of the Traffic Mirror target. Defaults to None.
        tag_specifications(List, optional): The tags to assign to the Traffic Mirror target. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.target.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.target.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_traffic_mirror_target",
        op_kwargs={
            "NetworkInterfaceId": network_interface_id,
            "NetworkLoadBalancerArn": network_load_balancer_arn,
            "Description": description,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, traffic_mirror_target_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Traffic Mirror target. You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror session.

    Args:
        traffic_mirror_target_id(str): The ID of the Traffic Mirror target.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.target.delete(
                ctx, traffic_mirror_target_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.target.delete traffic_mirror_target_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_traffic_mirror_target",
        op_kwargs={
            "TrafficMirrorTargetId": traffic_mirror_target_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    traffic_mirror_target_ids: List = None,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Information about one or more Traffic Mirror targets.

    Args:
        traffic_mirror_target_ids(List, optional): The ID of the Traffic Mirror targets. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    description: The Traffic Mirror target description.    network-interface-id: The ID of the Traffic Mirror session network interface.    network-load-balancer-arn: The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the session.    owner-id: The ID of the account that owns the Traffic Mirror session.    traffic-mirror-target-id: The ID of the Traffic Mirror target.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.target.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.target.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_traffic_mirror_targets",
        op_kwargs={
            "TrafficMirrorTargetIds": traffic_mirror_target_ids,
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
