"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    network_interface_id: str,
    traffic_mirror_target_id: str,
    traffic_mirror_filter_id: str,
    session_number: int,
    packet_length: int = None,
    virtual_network_id: int = None,
    description: str = None,
    tag_specifications: List = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Traffic Mirror session. A Traffic Mirror session actively copies packets from a Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to the session to define a subset of the traffic to mirror, for example all TCP traffic. The Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the same VPC, or in a different VPC connected via VPC peering or a transit gateway.  By default, no traffic is mirrored. Use CreateTrafficMirrorFilter to create filter rules that specify the traffic to mirror.

    Args:
        network_interface_id(str): The ID of the source network interface.
        traffic_mirror_target_id(str): The ID of the Traffic Mirror target.
        traffic_mirror_filter_id(str): The ID of the Traffic Mirror filter.
        packet_length(int, optional): The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. If you do not want to mirror the entire packet, use the PacketLength parameter to specify the number of bytes in each packet to mirror. Defaults to None.
        session_number(int): The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets. Valid values are 1-32766.
        virtual_network_id(int, optional): The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random. Defaults to None.
        description(str, optional): The description of the Traffic Mirror session. Defaults to None.
        tag_specifications(List, optional): The tags to assign to a Traffic Mirror session. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.session.create(
                ctx,
                network_interface_id=value,
                traffic_mirror_target_id=value,
                traffic_mirror_filter_id=value,
                session_number=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.session.create network_interface_id=value, traffic_mirror_target_id=value, traffic_mirror_filter_id=value, session_number=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_traffic_mirror_session",
        op_kwargs={
            "NetworkInterfaceId": network_interface_id,
            "TrafficMirrorTargetId": traffic_mirror_target_id,
            "TrafficMirrorFilterId": traffic_mirror_filter_id,
            "PacketLength": packet_length,
            "SessionNumber": session_number,
            "VirtualNetworkId": virtual_network_id,
            "Description": description,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def delete(
    hub, ctx, traffic_mirror_session_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Traffic Mirror session.

    Args:
        traffic_mirror_session_id(str): The ID of the Traffic Mirror session.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.session.delete(
                ctx, traffic_mirror_session_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.session.delete traffic_mirror_session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_traffic_mirror_session",
        op_kwargs={
            "TrafficMirrorSessionId": traffic_mirror_session_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    traffic_mirror_session_ids: List = None,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are described. Alternatively, you can filter the results.

    Args:
        traffic_mirror_session_ids(List, optional): The ID of the Traffic Mirror session. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    description: The Traffic Mirror session description.    network-interface-id: The ID of the Traffic Mirror session network interface.    owner-id: The ID of the account that owns the Traffic Mirror session.    packet-length: The assigned number of packets to mirror.     session-number: The assigned session number.     traffic-mirror-filter-id: The ID of the Traffic Mirror filter.    traffic-mirror-session-id: The ID of the Traffic Mirror session.    traffic-mirror-target-id: The ID of the Traffic Mirror target.    virtual-network-id: The virtual network ID of the Traffic Mirror session.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.session.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.session.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_traffic_mirror_sessions",
        op_kwargs={
            "TrafficMirrorSessionIds": traffic_mirror_session_ids,
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def modify(
    hub,
    ctx,
    traffic_mirror_session_id: str,
    traffic_mirror_target_id: str = None,
    traffic_mirror_filter_id: str = None,
    packet_length: int = None,
    session_number: int = None,
    virtual_network_id: int = None,
    description: str = None,
    remove_fields: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a Traffic Mirror session.

    Args:
        traffic_mirror_session_id(str): The ID of the Traffic Mirror session.
        traffic_mirror_target_id(str, optional): The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection with the source. Defaults to None.
        traffic_mirror_filter_id(str, optional): The ID of the Traffic Mirror filter. Defaults to None.
        packet_length(int, optional): The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the entire packet. Defaults to None.
        session_number(int, optional): The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets. Valid values are 1-32766. Defaults to None.
        virtual_network_id(int, optional): The virtual network ID of the Traffic Mirror session. Defaults to None.
        description(str, optional): The description to assign to the Traffic Mirror session. Defaults to None.
        remove_fields(List, optional): The properties that you want to remove from the Traffic Mirror session. When you remove a property from a Traffic Mirror session, the property is set to the default. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.session.modify(
                ctx, traffic_mirror_session_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.session.modify traffic_mirror_session_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_traffic_mirror_session",
        op_kwargs={
            "TrafficMirrorSessionId": traffic_mirror_session_id,
            "TrafficMirrorTargetId": traffic_mirror_target_id,
            "TrafficMirrorFilterId": traffic_mirror_filter_id,
            "PacketLength": packet_length,
            "SessionNumber": session_number,
            "VirtualNetworkId": virtual_network_id,
            "Description": description,
            "RemoveFields": remove_fields,
            "DryRun": dry_run,
        },
    )
