"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    traffic_mirror_filter_id: str,
    traffic_direction: str,
    rule_number: int,
    rule_action: str,
    destination_cidr_block: str,
    source_cidr_block: str,
    destination_port_range: Dict = None,
    source_port_range: Dict = None,
    protocol: int = None,
    description: str = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Traffic Mirror filter rule.  A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror. You need the Traffic Mirror filter ID when you create the rule.

    Args:
        traffic_mirror_filter_id(str): The ID of the filter that this rule is associated with.
        traffic_direction(str): The type of traffic (ingress | egress).
        rule_number(int): The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
        rule_action(str): The action to take (accept | reject) on the filtered traffic.
        destination_port_range(Dict, optional): The destination port range. Defaults to None.
        source_port_range(Dict, optional): The source port range. Defaults to None.
        protocol(int, optional): The protocol, for example UDP, to assign to the Traffic Mirror rule. For information about the protocol value, see Protocol Numbers on the Internet Assigned Numbers Authority (IANA) website. Defaults to None.
        destination_cidr_block(str): The destination CIDR block to assign to the Traffic Mirror rule.
        source_cidr_block(str): The source CIDR block to assign to the Traffic Mirror rule.
        description(str, optional): The description of the Traffic Mirror rule. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.rule.create(
                ctx,
                traffic_mirror_filter_id=value,
                traffic_direction=value,
                rule_number=value,
                rule_action=value,
                destination_cidr_block=value,
                source_cidr_block=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.rule.create traffic_mirror_filter_id=value, traffic_direction=value, rule_number=value, rule_action=value, destination_cidr_block=value, source_cidr_block=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_traffic_mirror_filter_rule",
        op_kwargs={
            "TrafficMirrorFilterId": traffic_mirror_filter_id,
            "TrafficDirection": traffic_direction,
            "RuleNumber": rule_number,
            "RuleAction": rule_action,
            "DestinationPortRange": destination_port_range,
            "SourcePortRange": source_port_range,
            "Protocol": protocol,
            "DestinationCidrBlock": destination_cidr_block,
            "SourceCidrBlock": source_cidr_block,
            "Description": description,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def delete(
    hub, ctx, traffic_mirror_filter_rule_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Traffic Mirror rule.

    Args:
        traffic_mirror_filter_rule_id(str): The ID of the Traffic Mirror rule.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.rule.delete(
                ctx, traffic_mirror_filter_rule_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.rule.delete traffic_mirror_filter_rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_traffic_mirror_filter_rule",
        op_kwargs={
            "TrafficMirrorFilterRuleId": traffic_mirror_filter_rule_id,
            "DryRun": dry_run,
        },
    )


async def modify(
    hub,
    ctx,
    traffic_mirror_filter_rule_id: str,
    traffic_direction: str = None,
    rule_number: int = None,
    rule_action: str = None,
    destination_port_range: Dict = None,
    source_port_range: Dict = None,
    protocol: int = None,
    destination_cidr_block: str = None,
    source_cidr_block: str = None,
    description: str = None,
    remove_fields: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified Traffic Mirror rule.  DestinationCidrBlock and SourceCidrBlock must both be an IPv4 range or an IPv6 range.

    Args:
        traffic_mirror_filter_rule_id(str): The ID of the Traffic Mirror rule.
        traffic_direction(str, optional): The type of traffic (ingress | egress) to assign to the rule. Defaults to None.
        rule_number(int, optional): The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number. Defaults to None.
        rule_action(str, optional): The action to assign to the rule. Defaults to None.
        destination_port_range(Dict, optional): The destination ports that are associated with the Traffic Mirror rule. Defaults to None.
        source_port_range(Dict, optional): The port range to assign to the Traffic Mirror rule. Defaults to None.
        protocol(int, optional): The protocol, for example TCP, to assign to the Traffic Mirror rule. Defaults to None.
        destination_cidr_block(str, optional): The destination CIDR block to assign to the Traffic Mirror rule. Defaults to None.
        source_cidr_block(str, optional): The source CIDR block to assign to the Traffic Mirror rule. Defaults to None.
        description(str, optional): The description to assign to the Traffic Mirror rule. Defaults to None.
        remove_fields(List, optional): The properties that you want to remove from the Traffic Mirror filter rule. When you remove a property from a Traffic Mirror filter rule, the property is set to the default. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.rule.modify(
                ctx, traffic_mirror_filter_rule_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.rule.modify traffic_mirror_filter_rule_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_traffic_mirror_filter_rule",
        op_kwargs={
            "TrafficMirrorFilterRuleId": traffic_mirror_filter_rule_id,
            "TrafficDirection": traffic_direction,
            "RuleNumber": rule_number,
            "RuleAction": rule_action,
            "DestinationPortRange": destination_port_range,
            "SourcePortRange": source_port_range,
            "Protocol": protocol,
            "DestinationCidrBlock": destination_cidr_block,
            "SourceCidrBlock": source_cidr_block,
            "Description": description,
            "RemoveFields": remove_fields,
            "DryRun": dry_run,
        },
    )
