"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def modify(
    hub,
    ctx,
    traffic_mirror_filter_id: str,
    add_network_services: List = None,
    remove_network_services: List = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allows or restricts mirroring network services.  By default, Amazon DNS network services are not eligible for Traffic Mirror. Use AddNetworkServices to add network services to a Traffic Mirror filter. When a network service is added to the Traffic Mirror filter, all traffic related to that network service will be mirrored. When you no longer want to mirror network services, use RemoveNetworkServices to remove the network services from the Traffic Mirror filter.  For information about filter rule properties, see Network Services in the Traffic Mirroring User Guide .

    Args:
        traffic_mirror_filter_id(str): The ID of the Traffic Mirror filter.
        add_network_services(List, optional): The network service, for example Amazon DNS, that you want to mirror. Defaults to None.
        remove_network_services(List, optional): The network service, for example Amazon DNS, that you no longer want to mirror. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.network_service.modify(
                ctx, traffic_mirror_filter_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.network_service.modify traffic_mirror_filter_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_traffic_mirror_filter_network_services",
        op_kwargs={
            "TrafficMirrorFilterId": traffic_mirror_filter_id,
            "AddNetworkServices": add_network_services,
            "RemoveNetworkServices": remove_network_services,
            "DryRun": dry_run,
        },
    )
