"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    description: str = None,
    tag_specifications: List = None,
    dry_run: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Traffic Mirror filter. A Traffic Mirror filter is a set of rules that defines the traffic to mirror. By default, no traffic is mirrored. To mirror traffic, use CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you add define what traffic gets mirrored. You can also use ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.

    Args:
        description(str, optional): The description of the Traffic Mirror filter. Defaults to None.
        tag_specifications(List, optional): The tags to assign to a Traffic Mirror filter. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_traffic_mirror_filter",
        op_kwargs={
            "Description": description,
            "TagSpecifications": tag_specifications,
            "DryRun": dry_run,
            "ClientToken": client_token,
        },
    )


async def delete(hub, ctx, traffic_mirror_filter_id: str, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified Traffic Mirror filter. You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror session.

    Args:
        traffic_mirror_filter_id(str): The ID of the Traffic Mirror filter.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.init.delete(
                ctx, traffic_mirror_filter_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.init.delete traffic_mirror_filter_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_traffic_mirror_filter",
        op_kwargs={
            "TrafficMirrorFilterId": traffic_mirror_filter_id,
            "DryRun": dry_run,
        },
    )


async def describe_all(
    hub,
    ctx,
    traffic_mirror_filter_ids: List = None,
    dry_run: bool = None,
    filters: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more Traffic Mirror filters.

    Args:
        traffic_mirror_filter_ids(List, optional): The ID of the Traffic Mirror filter. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        filters(List, optional): One or more filters. The possible values are:    description: The Traffic Mirror filter description.    traffic-mirror-filter-id: The ID of the Traffic Mirror filter.  . Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.traffic_mirror.filter_.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.traffic_mirror.filter_.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_traffic_mirror_filters",
        op_kwargs={
            "TrafficMirrorFilterIds": traffic_mirror_filter_ids,
            "DryRun": dry_run,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
