"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subnet_id: str,
    cidr: str,
    reservation_type: str,
    tag_specifications: List = None,
    description: str = None,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see Subnet CIDR reservations in the Amazon Virtual Private Cloud User Guide.

    Args:
        tag_specifications(List, optional): The tags to assign to the subnet CIDR reservation. Defaults to None.
        subnet_id(str): The ID of the subnet.
        cidr(str): The IPv4 or IPV6 CIDR range to reserve.
        reservation_type(str): The type of reservation. The following are valid values:    prefix: The Amazon EC2 Prefix Delegation feature assigns the IP addresses to network interfaces that are associated with an instance. For information about Prefix Delegation, see Prefix Delegation for Amazon EC2 network interfaces in the Amazon Elastic Compute Cloud User Guide.    explicit: You manually assign the IP addresses to resources that reside in your subnet.   .
        description(str, optional): The description to assign to the subnet CIDR reservation. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.subnet.cidr.reservation.create(
                ctx, subnet_id=value, cidr=value, reservation_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.subnet.cidr.reservation.create subnet_id=value, cidr=value, reservation_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_subnet_cidr_reservation",
        op_kwargs={
            "TagSpecifications": tag_specifications,
            "SubnetId": subnet_id,
            "Cidr": cidr,
            "ReservationType": reservation_type,
            "Description": description,
            "DryRun": dry_run,
        },
    )


async def delete(
    hub, ctx, subnet_cidr_reservation_id: str, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a subnet CIDR reservation.

    Args:
        subnet_cidr_reservation_id(str): The ID of the subnet CIDR reservation.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.subnet.cidr.reservation.delete(
                ctx, subnet_cidr_reservation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.subnet.cidr.reservation.delete subnet_cidr_reservation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_subnet_cidr_reservation",
        op_kwargs={
            "SubnetCidrReservationId": subnet_cidr_reservation_id,
            "DryRun": dry_run,
        },
    )


async def get_all(
    hub,
    ctx,
    subnet_id: str,
    filters: List = None,
    dry_run: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the subnet CIDR reservations.

    Args:
        filters(List, optional): One or more filters.    reservationType - The type of reservation (prefix | explicit).    subnet-id - The ID of the subnet.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.  . Defaults to None.
        subnet_id(str): The ID of the subnet.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.subnet.cidr.reservation.get_all(ctx, subnet_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.subnet.cidr.reservation.get_all subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_subnet_cidr_reservations",
        op_kwargs={
            "Filters": filters,
            "SubnetId": subnet_id,
            "DryRun": dry_run,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
