"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, ipv6_cidr_block: str, subnet_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a prefix length of /64.

    Args:
        ipv6_cidr_block(str): The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix length.
        subnet_id(str): The ID of your subnet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.subnet.cidr.block.associate(
                ctx, ipv6_cidr_block=value, subnet_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.subnet.cidr.block.associate ipv6_cidr_block=value, subnet_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="associate_subnet_cidr_block",
        op_kwargs={"Ipv6CidrBlock": ipv6_cidr_block, "SubnetId": subnet_id},
    )


async def disassociate(hub, ctx, association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR block only. You must detach or delete all gateways and resources that are associated with the CIDR block before you can disassociate it.

    Args:
        association_id(str): The association ID for the CIDR block.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.subnet.cidr.block.disassociate(ctx, association_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.subnet.cidr.block.disassociate association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="disassociate_subnet_cidr_block",
        op_kwargs={"AssociationId": association_id},
    )
