"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    filters: List = None,
    availability_zone: str = None,
    dry_run: bool = None,
    end_time: str = None,
    instance_types: List = None,
    max_results: int = None,
    next_token: str = None,
    product_descriptions: List = None,
    start_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the Spot price history. For more information, see Spot Instance pricing history in the Amazon EC2 User Guide for Linux Instances. When you specify a start and end time, the operation returns the prices of the instance types within that time range. It also returns the last price change before the start time, which is the effective price as of the start time.

    Args:
        filters(List, optional): One or more filters.    availability-zone - The Availability Zone for which prices should be returned.    instance-type - The type of instance (for example, m3.medium).    product-description - The product description for the Spot price (Linux/UNIX | Red Hat Enterprise Linux | SUSE Linux | Windows | Linux/UNIX (Amazon VPC) | Red Hat Enterprise Linux (Amazon VPC) | SUSE Linux (Amazon VPC) | Windows (Amazon VPC)).    spot-price - The Spot price. The value must match exactly (or use wildcards; greater than or less than comparison is not supported).    timestamp - The time stamp of the Spot price history, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). You can use wildcards (* and ?). Greater than or less than comparison is not supported.  . Defaults to None.
        availability_zone(str, optional): Filters the results by the specified Availability Zone. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        end_time(str, optional): The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). Defaults to None.
        instance_types(List, optional): Filters the results by the specified instance types. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        product_descriptions(List, optional): Filters the results by the specified basic product descriptions. Defaults to None.
        start_time(str, optional): The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.price_history.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.price_history.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_spot_price_history",
        op_kwargs={
            "Filters": filters,
            "AvailabilityZone": availability_zone,
            "DryRun": dry_run,
            "EndTime": end_time,
            "InstanceTypes": instance_types,
            "MaxResults": max_results,
            "NextToken": next_token,
            "ProductDescriptions": product_descriptions,
            "StartTime": start_time,
        },
    )
