"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def request(
    hub,
    ctx,
    availability_zone_group: str = None,
    block_duration_minutes: int = None,
    client_token: str = None,
    dry_run: bool = None,
    instance_count: int = None,
    launch_group: str = None,
    launch_specification: Dict = None,
    spot_price: str = None,
    type_: str = None,
    valid_from: str = None,
    valid_until: str = None,
    tag_specifications: List = None,
    instance_interruption_behavior: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Spot Instance request. For more information, see Spot Instance requests in the Amazon EC2 User Guide for Linux Instances.

    Args:
        availability_zone_group(str, optional): The user-specified name for a logical grouping of requests. When you specify an Availability Zone group in a Spot Instance request, all Spot Instances in the request are launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice of Availability Zone is not. The group applies only to requests for Spot Instances of the same instance type. Any additional Spot Instance requests that are specified with the same Availability Zone group name are launched in that same Availability Zone, as long as at least one instance from the group is still active. If there is no active instance running in the Availability Zone group that you specify for a new Spot Instance request (all instances are terminated, the request is expired, or the maximum price you specified falls below current Spot price), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently, the subsequent set of Spot Instances could be placed in a different zone from the original request, even if you specified the same Availability Zone group. Default: Instances are launched in any available Availability Zone. Defaults to None.
        block_duration_minutes(int, optional): Deprecated. Defaults to None.
        client_token(str, optional): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see How to Ensure Idempotency in the Amazon EC2 User Guide for Linux Instances. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        instance_count(int, optional): The maximum number of Spot Instances to launch. Default: 1. Defaults to None.
        launch_group(str, optional): The instance launch group. Launch groups are Spot Instances that launch together and terminate together. Default: Instances are launched and terminated individually. Defaults to None.
        launch_specification(Dict, optional): The launch specification. Defaults to None.
        spot_price(str, optional): The maximum price per hour that you are willing to pay for a Spot Instance. The default is the On-Demand price. Defaults to None.
        type_(str, optional): The Spot Instance request type. Default: one-time . Defaults to None.
        valid_from(str, optional): The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled. The specified start date and time cannot be equal to the current date and time. You must specify a start date and time that occurs after the current date and time. Defaults to None.
        valid_until(str, optional): The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ).   For a persistent request, the request remains active until the ValidUntil date and time is reached. Otherwise, the request remains active until you cancel it.    For a one-time request, the request remains active until all instances launch, the request is canceled, or the ValidUntil date and time is reached. By default, the request is valid for 7 days from the date the request was created.  . Defaults to None.
        tag_specifications(List, optional): The key-value pair for tagging the Spot Instance request on creation. The value for ResourceType must be spot-instances-request, otherwise the Spot Instance request fails. To tag the Spot Instance request after it has been created, see CreateTags. . Defaults to None.
        instance_interruption_behavior(str, optional): The behavior when a Spot Instance is interrupted. The default is terminate. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.instance.init.request(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.instance.init.request
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="request_spot_instances",
        op_kwargs={
            "AvailabilityZoneGroup": availability_zone_group,
            "BlockDurationMinutes": block_duration_minutes,
            "ClientToken": client_token,
            "DryRun": dry_run,
            "InstanceCount": instance_count,
            "LaunchGroup": launch_group,
            "LaunchSpecification": launch_specification,
            "SpotPrice": spot_price,
            "Type": type_,
            "ValidFrom": valid_from,
            "ValidUntil": valid_until,
            "TagSpecifications": tag_specifications,
            "InstanceInterruptionBehavior": instance_interruption_behavior,
        },
    )
