"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(
    hub,
    ctx,
    spot_fleet_request_ids: List,
    terminate_instances: bool,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified Spot Fleet requests. After you cancel a Spot Fleet request, the Spot Fleet launches no new Spot Instances. You must specify whether the Spot Fleet should also terminate its Spot Instances. If you terminate the instances, the Spot Fleet request enters the cancelled_terminating state. Otherwise, the Spot Fleet request enters the cancelled_running state and the instances continue to run until they are interrupted or you terminate them manually.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        spot_fleet_request_ids(List): The IDs of the Spot Fleet requests.
        terminate_instances(bool): Indicates whether to terminate instances for a Spot Fleet request if it is canceled successfully.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.fleet.request.init.cancel(
                ctx, spot_fleet_request_ids=value, terminate_instances=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.fleet.request.init.cancel spot_fleet_request_ids=value, terminate_instances=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="cancel_spot_fleet_requests",
        op_kwargs={
            "DryRun": dry_run,
            "SpotFleetRequestIds": spot_fleet_request_ids,
            "TerminateInstances": terminate_instances,
        },
    )


async def describe_all(
    hub,
    ctx,
    dry_run: bool = None,
    max_results: int = None,
    next_token: str = None,
    spot_fleet_request_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes your Spot Fleet requests. Spot Fleet requests are deleted 48 hours after they are canceled and their instances are terminated.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value is 1000. To retrieve the remaining results, make another call with the returned NextToken value. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        spot_fleet_request_ids(List, optional): The IDs of the Spot Fleet requests. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.fleet.request.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.fleet.request.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_spot_fleet_requests",
        op_kwargs={
            "DryRun": dry_run,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SpotFleetRequestIds": spot_fleet_request_ids,
        },
    )


async def modify(
    hub,
    ctx,
    spot_fleet_request_id: str,
    excess_capacity_termination_policy: str = None,
    launch_template_configs: List = None,
    target_capacity: int = None,
    on_demand_target_capacity: int = None,
    context: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the specified Spot Fleet request. You can only modify a Spot Fleet request of type maintain. While the Spot Fleet request is being modified, it is in the modifying state. To scale up your Spot Fleet, increase its target capacity. The Spot Fleet launches the additional Spot Instances according to the allocation strategy for the Spot Fleet request. If the allocation strategy is lowestPrice, the Spot Fleet launches instances using the Spot Instance pool with the lowest price. If the allocation strategy is diversified, the Spot Fleet distributes the instances across the Spot Instance pools. If the allocation strategy is capacityOptimized, Spot Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To scale down your Spot Fleet, decrease its target capacity. First, the Spot Fleet cancels any open requests that exceed the new target capacity. You can request that the Spot Fleet terminate Spot Instances until the size of the fleet no longer exceeds the new target capacity. If the allocation strategy is lowestPrice, the Spot Fleet terminates the instances with the highest price per unit. If the allocation strategy is capacityOptimized, the Spot Fleet terminates the instances in the Spot Instance pools that have the least available Spot Instance capacity. If the allocation strategy is diversified, the Spot Fleet terminates instances across the Spot Instance pools. Alternatively, you can request that the Spot Fleet keep the fleet at its current size, but not replace any Spot Instances that are interrupted or that you terminate manually. If you are finished with your Spot Fleet for now, but will use it again later, you can set the target capacity to 0.

    Args:
        excess_capacity_termination_policy(str, optional): Indicates whether running Spot Instances should be terminated if the target capacity of the Spot Fleet request is decreased below the current size of the Spot Fleet. Defaults to None.
        launch_template_configs(List, optional): The launch template and overrides. You can only use this parameter if you specified a launch template (LaunchTemplateConfigs) in your Spot Fleet request. If you specified LaunchSpecifications in your Spot Fleet request, then omit this parameter. Defaults to None.
        spot_fleet_request_id(str): The ID of the Spot Fleet request.
        target_capacity(int, optional): The size of the fleet. Defaults to None.
        on_demand_target_capacity(int, optional): The number of On-Demand Instances in the fleet. Defaults to None.
        context(str, optional): Reserved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.fleet.request.init.modify(
                ctx, spot_fleet_request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.fleet.request.init.modify spot_fleet_request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_spot_fleet_request",
        op_kwargs={
            "ExcessCapacityTerminationPolicy": excess_capacity_termination_policy,
            "LaunchTemplateConfigs": launch_template_configs,
            "SpotFleetRequestId": spot_fleet_request_id,
            "TargetCapacity": target_capacity,
            "OnDemandTargetCapacity": on_demand_target_capacity,
            "Context": context,
        },
    )
