"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def request(
    hub, ctx, spot_fleet_request_config: Dict, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Spot Fleet request. The Spot Fleet request specifies the total target capacity and the On-Demand target capacity. Amazon EC2 calculates the difference between the total capacity and On-Demand capacity, and launches the difference as Spot capacity. You can submit a single request that includes multiple launch specifications that vary by instance type, AMI, Availability Zone, or subnet. By default, the Spot Fleet requests Spot Instances in the Spot Instance pool where the price per unit is the lowest. Each launch specification can include its own instance weighting that reflects the value of the instance type to your application workload. Alternatively, you can specify that the Spot Fleet distribute the target capacity across the Spot pools included in its launch specifications. By ensuring that the Spot Instances in your Spot Fleet are in different Spot pools, you can improve the availability of your fleet. You can specify tags for the Spot Fleet request and instances launched by the fleet. You cannot tag other resource types in a Spot Fleet request because only the spot-fleet-request and instance resource types are supported. For more information, see Spot Fleet requests in the Amazon EC2 User Guide for Linux Instances.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        spot_fleet_request_config(Dict): The configuration for the Spot Fleet request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.fleet.init.request(
                ctx, spot_fleet_request_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.fleet.init.request spot_fleet_request_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="request_spot_fleet",
        op_kwargs={
            "DryRun": dry_run,
            "SpotFleetRequestConfig": spot_fleet_request_config,
        },
    )
