"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, bucket: str, dry_run: bool = None, prefix: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You can create one data feed per Amazon Web Services account. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.

    Args:
        bucket(str): The name of the Amazon S3 bucket in which to store the Spot Instance data feed. For more information about bucket names, see Rules for bucket naming in the Amazon S3 Developer Guide.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        prefix(str, optional): The prefix for the data feed file names. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.datafeed_subscription.create(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.datafeed_subscription.create bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="create_spot_datafeed_subscription",
        op_kwargs={"Bucket": bucket, "DryRun": dry_run, "Prefix": prefix},
    )


async def delete(hub, ctx, dry_run: bool = None) -> None:
    r"""
    **Autogenerated function**

    Deletes the data feed for Spot Instances.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.datafeed_subscription.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.datafeed_subscription.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="delete_spot_datafeed_subscription",
        op_kwargs={"DryRun": dry_run},
    )


async def describe(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the data feed for Spot Instances. For more information, see Spot Instance data feed in the Amazon EC2 User Guide for Linux Instances.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.spot.datafeed_subscription.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.spot.datafeed_subscription.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_spot_datafeed_subscription",
        op_kwargs={"DryRun": dry_run},
    )
