"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the access status of your account to the EC2 serial console of all instances. By default, access to the EC2 serial console is disabled for your account. For more information, see Manage account access to the EC2 serial console in the Amazon EC2 User Guide.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.serial_console_access.status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.serial_console_access.status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="get_serial_console_access_status",
        op_kwargs={"DryRun": dry_run},
    )
