"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def apply(
    hub,
    ctx,
    client_vpn_endpoint_id: str,
    vpc_id: str,
    security_group_ids: List,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.

    Args:
        client_vpn_endpoint_id(str): The ID of the Client VPN endpoint.
        vpc_id(str): The ID of the VPC in which the associated target network is located.
        security_group_ids(List): The IDs of the security groups to apply to the associated target network. Up to 5 security groups can be applied to an associated target network.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.to_client_vpn_target_network.apply(
                ctx, client_vpn_endpoint_id=value, vpc_id=value, security_group_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.to_client_vpn_target_network.apply client_vpn_endpoint_id=value, vpc_id=value, security_group_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="apply_security_groups_to_client_vpn_target_network",
        op_kwargs={
            "ClientVpnEndpointId": client_vpn_endpoint_id,
            "VpcId": vpc_id,
            "SecurityGroupIds": security_group_ids,
            "DryRun": dry_run,
        },
    )
