"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    filters: List = None,
    security_group_rule_ids: List = None,
    dry_run: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of your security group rules.

    Args:
        filters(List, optional): One or more filters.    group-id - The ID of the security group.    security-group-rule-id - The ID of the security group rule.    tag:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.  . Defaults to None.
        security_group_rule_ids(List, optional): The IDs of the security group rules. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another request with the returned NextToken value. This value can be between 5 and 1000. If this parameter is not specified, then all results are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.rule.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.rule.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_security_group_rules",
        op_kwargs={
            "Filters": filters,
            "SecurityGroupRuleIds": security_group_rule_ids,
            "DryRun": dry_run,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def modify(
    hub, ctx, group_id: str, security_group_rules: List, dry_run: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the rules of a security group.

    Args:
        group_id(str): The ID of the security group.
        security_group_rules(List): Information about the security group properties to update.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.rule.init.modify(
                ctx, group_id=value, security_group_rules=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.rule.init.modify group_id=value, security_group_rules=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="modify_security_group_rules",
        op_kwargs={
            "GroupId": group_id,
            "SecurityGroupRules": security_group_rules,
            "DryRun": dry_run,
        },
    )
