"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(
    hub,
    ctx,
    dry_run: bool = None,
    group_id: str = None,
    group_name: str = None,
    ip_permissions: List = None,
    security_group_rule_descriptions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_id(str, optional): The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID. Defaults to None.
        group_name(str, optional): [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request. Defaults to None.
        ip_permissions(List, optional): The IP permissions for the security group rule. You must specify either IP permissions or a description. Defaults to None.
        security_group_rule_descriptions(List, optional): [VPC only] The description for the ingress security group rules. You must specify either a description or IP permissions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.rule.description.ingress.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.rule.description.ingress.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="update_security_group_rule_descriptions_ingress",
        op_kwargs={
            "DryRun": dry_run,
            "GroupId": group_id,
            "GroupName": group_name,
            "IpPermissions": ip_permissions,
            "SecurityGroupRuleDescriptions": security_group_rule_descriptions,
        },
    )
