"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(hub, ctx, group_id: List, dry_run: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    [VPC only] Describes the VPCs on the other side of a VPC peering connection that are referencing the security groups you've specified in this request.

    Args:
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        group_id(List): The IDs of the security groups in your account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.reference.describe_all(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.reference.describe_all group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="describe_security_group_references",
        op_kwargs={"DryRun": dry_run, "GroupId": group_id},
    )
