"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def authorize(
    hub,
    ctx,
    cidr_ip: str = None,
    from_port: int = None,
    group_id: str = None,
    group_name: str = None,
    ip_permissions: List = None,
    ip_protocol: str = None,
    source_security_group_name: str = None,
    source_security_group_owner_id: str = None,
    to_port: int = None,
    dry_run: bool = None,
    tag_specifications: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds the specified inbound (ingress) rules to a security group. An inbound rule permits instances to receive traffic from the specified IPv4 or IPv6 CIDR address range, or from the instances that are associated with the specified destination security groups. You specify a protocol for each rule (for example, TCP). For TCP and UDP, you must also specify the destination port or port range. For ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You can use -1 to mean all types or all codes. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur. For more information about VPC security group quotas, see Amazon VPC quotas.

    Args:
        cidr_ip(str, optional): The IPv4 address range, in CIDR format. You can't specify this parameter when specifying a source security group. To specify an IPv6 address range, use a set of IP permissions. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule. Defaults to None.
        from_port(int, optional): The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use -1 to specify all types. If you specify all ICMP types, you must specify all codes. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule. Defaults to None.
        group_id(str, optional): The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID. Defaults to None.
        group_name(str, optional): [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request. Defaults to None.
        ip_permissions(List, optional): The sets of IP permissions. Defaults to None.
        ip_protocol(str, optional): The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers). To specify icmpv6, use a set of IP permissions. [VPC only] Use -1 to specify all protocols. If you specify -1 or a protocol other than tcp, udp, or icmp, traffic on all ports is allowed, regardless of any ports you specify. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule. Defaults to None.
        source_security_group_name(str, optional): [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. For EC2-VPC, the source security group must be in the same VPC. Defaults to None.
        source_security_group_owner_id(str, optional): [nondefault VPC] The Amazon Web Services account ID for the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. Creates rules that grant full ICMP, UDP, and TCP access. To create a rule with a specific IP protocol and port range, use a set of IP permissions instead. Defaults to None.
        to_port(int, optional): The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use -1 to specify all codes. If you specify all ICMP types, you must specify all codes. Alternatively, use a set of IP permissions to specify multiple rules and a description for the rule. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        tag_specifications(List, optional): [VPC Only] The tags applied to the security group rule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.ingress.authorize(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.ingress.authorize
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="authorize_security_group_ingress",
        op_kwargs={
            "CidrIp": cidr_ip,
            "FromPort": from_port,
            "GroupId": group_id,
            "GroupName": group_name,
            "IpPermissions": ip_permissions,
            "IpProtocol": ip_protocol,
            "SourceSecurityGroupName": source_security_group_name,
            "SourceSecurityGroupOwnerId": source_security_group_owner_id,
            "ToPort": to_port,
            "DryRun": dry_run,
            "TagSpecifications": tag_specifications,
        },
    )


async def revoke(
    hub,
    ctx,
    cidr_ip: str = None,
    from_port: int = None,
    group_id: str = None,
    group_name: str = None,
    ip_permissions: List = None,
    ip_protocol: str = None,
    source_security_group_name: str = None,
    source_security_group_owner_id: str = None,
    to_port: int = None,
    dry_run: bool = None,
    security_group_rule_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified inbound (ingress) rules from a security group. You can specify rules using either rule IDs or security group rule properties. If you use rule properties, the values that you specify (for example, ports) must match the existing rule's values exactly. Each rule has a protocol, from and to ports, and source (CIDR range, security group, or prefix list). For the TCP and UDP protocols, you must also specify the destination port or range of ports. For the ICMP protocol, you must also specify the ICMP type and code. If the security group rule has a description, you do not need to specify the description to revoke the rule. [EC2-Classic, default VPC] If the values you specify do not match the existing rule's values, no error is returned, and the output describes the security group rules that were not revoked. Amazon Web Services recommends that you describe the security group to verify that the rules were removed. Rule changes are propagated to instances within the security group as quickly as possible. However, a small delay might occur.

    Args:
        cidr_ip(str, optional): The CIDR IP address range. You can't specify this parameter when specifying a source security group. Defaults to None.
        from_port(int, optional): The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, use -1 to specify all ICMP types. Defaults to None.
        group_id(str, optional): The ID of the security group. You must specify either the security group ID or the security group name in the request. For security groups in a nondefault VPC, you must specify the security group ID. Defaults to None.
        group_name(str, optional): [EC2-Classic, default VPC] The name of the security group. You must specify either the security group ID or the security group name in the request. Defaults to None.
        ip_permissions(List, optional): The sets of IP permissions. You can't specify a source security group and a CIDR IP address range in the same set of permissions. Defaults to None.
        ip_protocol(str, optional): The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers). Use -1 to specify all. Defaults to None.
        source_security_group_name(str, optional): [EC2-Classic, default VPC] The name of the source security group. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the start of the port range, the IP protocol, and the end of the port range. For EC2-VPC, the source security group must be in the same VPC. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead. Defaults to None.
        source_security_group_owner_id(str, optional): [EC2-Classic] The Amazon Web Services account ID of the source security group, if the source security group is in a different account. You can't specify this parameter in combination with the following parameters: the CIDR IP address range, the IP protocol, the start of the port range, and the end of the port range. To revoke a specific rule for an IP protocol and port range, use a set of IP permissions instead. Defaults to None.
        to_port(int, optional): The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, use -1 to specify all ICMP codes for the ICMP type. Defaults to None.
        dry_run(bool, optional): Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation. Defaults to None.
        security_group_rule_ids(List, optional): The IDs of the security group rules. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ec2.security_group.ingress.revoke(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ec2.security_group.ingress.revoke
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ec2",
        operation="revoke_security_group_ingress",
        op_kwargs={
            "CidrIp": cidr_ip,
            "FromPort": from_port,
            "GroupId": group_id,
            "GroupName": group_name,
            "IpPermissions": ip_permissions,
            "IpProtocol": ip_protocol,
            "SourceSecurityGroupName": source_security_group_name,
            "SourceSecurityGroupOwnerId": source_security_group_owner_id,
            "ToPort": to_port,
            "DryRun": dry_run,
            "SecurityGroupRuleIds": security_group_rule_ids,
        },
    )
